/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.x11.GLX;
import net.java.games.jogl.impl.x11.X11GLContext;
import net.java.games.jogl.impl.x11.X11GLContextFactory;
import net.java.games.jogl.impl.x11.X11GLImpl;
import net.java.games.jogl.impl.x11.XVisualInfo;

public class X11OffscreenGLContext
extends X11GLContext {
    private long pixmap;
    private boolean isDoubleBuffered;
    private int width;
    private int height;

    public X11OffscreenGLContext(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(null, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new X11GLImpl(this);
    }

    protected boolean isOffscreen() {
        return true;
    }

    public int getOffscreenContextWidth() {
        return this.width;
    }

    public int getOffscreenContextHeight() {
        return this.height;
    }

    public int getOffscreenContextPixelDataType() {
        return 5121;
    }

    public int getOffscreenContextReadBuffer() {
        if (this.isDoubleBuffered) {
            return 1029;
        }
        return 1028;
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        return true;
    }

    public boolean canCreatePbufferContext() {
        return false;
    }

    public synchronized GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        this.display = X11GLContextFactory.getDisplayConnection();
        if (this.pendingOffscreenResize && (this.pendingOffscreenWidth != this.width || this.pendingOffscreenHeight != this.height)) {
            if (this.context != 0L) {
                this.destroy();
            }
            this.width = this.pendingOffscreenWidth;
            this.height = this.pendingOffscreenHeight;
            this.pendingOffscreenResize = false;
        }
        this.mostRecentDisplay = this.display;
        return super.makeCurrent(runnable);
    }

    public synchronized void swapBuffers() throws GLException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected synchronized void free() throws GLException {
        try {
            super.free();
        }
        finally {
            this.display = 0L;
        }
    }

    protected void create() {
        XVisualInfo xVisualInfo = this.chooseVisual();
        int n = xVisualInfo.depth();
        if (this.display == 0L) {
            throw new GLException("No active display");
        }
        int n2 = GLX.DefaultScreen(this.display);
        this.pixmap = GLX.XCreatePixmap(this.display, (int)GLX.RootWindow(this.display, n2), this.width, this.height, n);
        if (this.pixmap == 0L) {
            throw new GLException("XCreatePixmap failed");
        }
        this.drawable = GLX.glXCreateGLXPixmap(this.display, xVisualInfo, this.pixmap);
        if (this.drawable == 0L) {
            throw new GLException("glXCreateGLXPixmap failed");
        }
        this.context = this.createContext(xVisualInfo, false);
        if (this.context == 0L) {
            throw new GLException("Unable to create OpenGL context");
        }
        this.isDoubleBuffered = X11GLContextFactory.glXGetConfig(this.display, xVisualInfo, 5, new int[1]) != 0;
    }

    protected void destroyImpl() {
        if (this.context != 0L) {
            super.destroyImpl();
            GLX.glXDestroyContext(this.display, this.context);
            GLX.glXDestroyGLXPixmap(this.display, (int)this.drawable);
            GLX.XFreePixmap(this.display, this.pixmap);
            this.context = 0L;
            this.drawable = 0L;
            this.pixmap = 0L;
            GLContextShareSet.contextDestroyed(this);
        }
    }
}

