/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.windows;

import java.awt.Component;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.Rectangle;
import java.io.File;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextFactory;
import net.java.games.jogl.impl.SingleThreadedWorkaround;
import net.java.games.jogl.impl.windows.PIXELFORMATDESCRIPTOR;
import net.java.games.jogl.impl.windows.WGL;
import net.java.games.jogl.impl.windows.WindowsGLContext;
import net.java.games.jogl.impl.windows.WindowsOffscreenGLContext;
import net.java.games.jogl.impl.windows.WindowsOnscreenGLContext;

public class WindowsGLContextFactory
extends GLContextFactory {
    private static final boolean DEBUG = Debug.debug("WindowsGLContextFactory");
    private static final boolean VERBOSE = Debug.verbose();
    private static Map dummyContextMap = new HashMap();
    private static Map dummyExtensionsMap = new HashMap();
    private static Set pendingContextSet = new HashSet();
    static /* synthetic */ Class class$net$java$games$jogl$impl$windows$WindowsGLContextFactory;

    public WindowsGLContextFactory() {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                File file;
                Runtime.getRuntime().addShutdownHook(new ShutdownHook());
                String string = System.getProperty("java.io.tmpdir");
                if (string != null && (file = new File(string)).isAbsolute()) {
                    File file2 = null;
                    do {
                        if ((file2 = file.getParentFile()) == null) continue;
                        file = file2;
                    } while (file2 != null);
                    if ((file = new File(new File(new File(file, "windows"), "system32"), "atioglxx.dll")).exists()) {
                        SingleThreadedWorkaround.shouldDoWorkaround();
                    }
                }
                return null;
            }
        });
    }

    public GraphicsConfiguration chooseGraphicsConfiguration(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GraphicsDevice graphicsDevice) {
        return null;
    }

    public GLContext createGLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        if (component != null) {
            return new WindowsOnscreenGLContext(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
        }
        return new WindowsOffscreenGLContext(gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    public static WindowsGLContext getDummyGLContext(GraphicsDevice graphicsDevice) {
        WindowsGLContextFactory.checkForDummyContext(graphicsDevice);
        NativeWindowStruct nativeWindowStruct = (NativeWindowStruct)dummyContextMap.get(graphicsDevice);
        return nativeWindowStruct.getWindowsContext();
    }

    public static String getDummyGLExtensions(GraphicsDevice graphicsDevice) {
        WindowsGLContextFactory.checkForDummyContext(graphicsDevice);
        String string = (String)dummyExtensionsMap.get(graphicsDevice);
        return string == null ? "" : string;
    }

    public static GL getDummyGL(GraphicsDevice graphicsDevice) {
        WindowsGLContextFactory.checkForDummyContext(graphicsDevice);
        NativeWindowStruct nativeWindowStruct = (NativeWindowStruct)dummyContextMap.get(graphicsDevice);
        return nativeWindowStruct.getWindowsContext().getGL();
    }

    private static void checkForDummyContext(GraphicsDevice graphicsDevice) {
        if (!pendingContextSet.contains(graphicsDevice) && !dummyContextMap.containsKey(graphicsDevice)) {
            if (DEBUG) {
                System.err.println("WindowsGLContextFactory.checkForDummyContext() called on thread " + Thread.currentThread().getName());
            }
            pendingContextSet.add(graphicsDevice);
            GraphicsConfiguration graphicsConfiguration = graphicsDevice.getDefaultConfiguration();
            Rectangle rectangle = graphicsConfiguration.getBounds();
            GLCapabilities gLCapabilities = new GLCapabilities();
            gLCapabilities.setDepthBits(16);
            WindowsOnscreenGLContext windowsOnscreenGLContext = new WindowsOnscreenGLContext(null, gLCapabilities, null, null);
            NativeWindowThread nativeWindowThread = new NativeWindowThread(rectangle);
            nativeWindowThread.start();
            long l = 0L;
            long l2 = 0L;
            while ((l = nativeWindowThread.getHWND()) == 0L || (l2 = nativeWindowThread.getHDC()) == 0L) {
                Thread.yield();
            }
            PIXELFORMATDESCRIPTOR pIXELFORMATDESCRIPTOR = WindowsOnscreenGLContext.glCapabilities2PFD(gLCapabilities, true);
            int n = WGL.ChoosePixelFormat(l2, pIXELFORMATDESCRIPTOR);
            if (n == 0) {
                System.err.println("Pixel Format is Zero");
                pendingContextSet.remove(graphicsDevice);
                return;
            }
            if (!WGL.SetPixelFormat(l2, n, pIXELFORMATDESCRIPTOR)) {
                System.err.println("SetPixelFormat Failed");
                pendingContextSet.remove(graphicsDevice);
                return;
            }
            long l3 = WGL.wglCreateContext(l2);
            if (l == 0L || l2 == 0L || l3 == 0L) {
                pendingContextSet.remove(graphicsDevice);
                return;
            }
            NativeWindowStruct nativeWindowStruct = new NativeWindowStruct();
            nativeWindowStruct.setHWND(l);
            nativeWindowStruct.setWindowsContext(windowsOnscreenGLContext);
            nativeWindowStruct.setWindowThread(nativeWindowThread);
            long l4 = WGL.wglGetCurrentDC();
            long l5 = WGL.wglGetCurrentContext();
            if (!WGL.wglMakeCurrent(l2, l3)) {
                pendingContextSet.remove(graphicsDevice);
                return;
            }
            windowsOnscreenGLContext.hdc = l2;
            windowsOnscreenGLContext.hglrc = l3;
            windowsOnscreenGLContext.resetGLFunctionAvailability();
            windowsOnscreenGLContext.createGL();
            pendingContextSet.remove(graphicsDevice);
            dummyContextMap.put(graphicsDevice, nativeWindowStruct);
            String string = "";
            String string2 = "";
            String string3 = "";
            try {
                string2 = windowsOnscreenGLContext.getGL().wglGetExtensionsStringARB(l4);
            }
            catch (GLException gLException) {
                // empty catch block
            }
            try {
                string3 = windowsOnscreenGLContext.getGL().wglGetExtensionsStringEXT();
            }
            catch (GLException gLException) {
                // empty catch block
            }
            string = windowsOnscreenGLContext.getGL().glGetString(7939);
            dummyExtensionsMap.put(graphicsDevice, string + " " + string3 + " " + string2);
            WGL.wglMakeCurrent(l4, l5);
        }
    }

    class ShutdownHook
    extends Thread {
        ShutdownHook() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Collection collection = dummyContextMap.values();
            Iterator iterator = collection.iterator();
            while (iterator.hasNext()) {
                NativeWindowStruct nativeWindowStruct = (NativeWindowStruct)iterator.next();
                Thread thread = nativeWindowStruct.getWindowThread();
                synchronized (thread) {
                    nativeWindowStruct.getWindowThread().notifyAll();
                }
                if (!WGL.wglDeleteContext(nativeWindowStruct.getHGLRC())) {
                    System.err.println("Error Destroying NativeWindowStruct RC: " + WGL.GetLastError());
                }
                WGL.DestroyDummyWindow(nativeWindowStruct.getHWND(), nativeWindowStruct.getHDC());
            }
        }
    }

    static class NativeWindowThread
    extends Thread {
        private long HWND = 0L;
        private long HDC = 0L;
        private Rectangle rectangle;

        public NativeWindowThread(Rectangle rectangle) {
            this.rectangle = rectangle;
        }

        public synchronized long getHWND() {
            return this.HWND;
        }

        public synchronized long getHDC() {
            return this.HDC;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Class clazz = class$net$java$games$jogl$impl$windows$WindowsGLContextFactory == null ? (class$net$java$games$jogl$impl$windows$WindowsGLContextFactory = WindowsGLContextFactory.class$("net.java.games.jogl.impl.windows.WindowsGLContextFactory")) : class$net$java$games$jogl$impl$windows$WindowsGLContextFactory;
            synchronized (clazz) {
                this.HWND = WGL.CreateDummyWindow(this.rectangle.x, this.rectangle.y, this.rectangle.width, this.rectangle.height);
            }
            this.HDC = WGL.GetDC(this.HWND);
            WGL.NativeEventLoop();
        }
    }

    static class NativeWindowStruct {
        private long HWND;
        private WindowsGLContext windowsContext;
        private Thread windowThread;

        public long getHDC() {
            return this.windowsContext.hdc;
        }

        public long getHGLRC() {
            return this.windowsContext.hglrc;
        }

        public void setHWND(long l) {
            this.HWND = l;
        }

        public long getHWND() {
            return this.HWND;
        }

        public void setWindowsContext(WindowsGLContext windowsGLContext) {
            this.windowsContext = windowsGLContext;
        }

        public WindowsGLContext getWindowsContext() {
            return this.windowsContext;
        }

        public void setWindowThread(Thread thread) {
            this.windowThread = thread;
        }

        public Thread getWindowThread() {
            return this.windowThread;
        }
    }
}

