/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.security.AccessController;
import java.security.PrivilegedAction;
import net.java.games.jogl.impl.Debug;

public class SingleThreadedWorkaround {
    private static boolean singleThreadedWorkaround = true;
    private static boolean systemPropertySpecified = false;

    public static void disableWorkaround() {
        systemPropertySpecified = true;
        singleThreadedWorkaround = false;
        if (Debug.verbose()) {
            System.err.println("Application forced disabling of single-threaded workaround of dispatching display() on event thread");
        }
    }

    public static void shouldDoWorkaround() {
        if (!systemPropertySpecified) {
            singleThreadedWorkaround = true;
            SingleThreadedWorkaround.printWorkaroundNotice();
        }
    }

    public static boolean doWorkaround() {
        return singleThreadedWorkaround;
    }

    private static void printWorkaroundNotice() {
        if (singleThreadedWorkaround && Debug.verbose()) {
            System.err.println("Using single-threaded workaround of dispatching display() on event thread");
        }
    }

    static {
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("jogl.1thread");
                if (string == null) {
                    string = System.getProperty("JOGL_SINGLE_THREADED_WORKAROUND");
                }
                if (string == null) {
                    string = System.getProperty("ATI_WORKAROUND");
                }
                if (string != null && !string.equals("auto")) {
                    systemPropertySpecified = true;
                    singleThreadedWorkaround = Boolean.valueOf(string);
                }
                SingleThreadedWorkaround.printWorkaroundNotice();
                return null;
            }
        });
    }
}

