/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl;

import java.nio.DoubleBuffer;
import net.java.games.jogl.GL;
import net.java.games.jogl.util.BufferUtils;

class Project {
    private static final double[] IDENTITY_MATRIX = new double[]{1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0, 0.0, 0.0, 0.0, 0.0, 1.0};
    private final DoubleBuffer matrix = BufferUtils.newDoubleBuffer(16);
    private final double[] finalMatrix = new double[16];
    private final double[][] tempMatrix = new double[4][4];
    private final double[] in = new double[4];
    private final double[] out = new double[4];
    private final double[] forward = new double[3];
    private final double[] side = new double[3];
    private final double[] up = new double[3];

    Project() {
    }

    private void __gluMakeIdentityd(DoubleBuffer doubleBuffer) {
        int n = doubleBuffer.position();
        doubleBuffer.put(IDENTITY_MATRIX);
        doubleBuffer.position(n);
    }

    private void __gluMakeIdentityd(double[] dArray) {
        for (int i = 0; i < 16; ++i) {
            dArray[i] = IDENTITY_MATRIX[i];
        }
    }

    private void __gluMultMatrixVecd(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 4; ++i) {
            dArray3[i] = dArray2[0] * dArray[0 + i] + dArray2[1] * dArray[4 + i] + dArray2[2] * dArray[8 + i] + dArray2[3] * dArray[12 + i];
        }
    }

    private boolean __gluInvertMatrixd(double[] dArray, double[] dArray2) {
        int n;
        int n2;
        double[][] dArray3 = this.tempMatrix;
        for (n2 = 0; n2 < 4; ++n2) {
            for (n = 0; n < 4; ++n) {
                dArray3[n2][n] = dArray[n2 * 4 + n];
            }
        }
        this.__gluMakeIdentityd(dArray2);
        for (n2 = 0; n2 < 4; ++n2) {
            double d;
            int n3;
            int n4 = n2;
            for (n = n2 + 1; n < 4; ++n) {
                if (!(Math.abs(dArray3[n][n2]) > Math.abs(dArray3[n2][n2]))) continue;
                n4 = n;
            }
            if (n4 != n2) {
                for (n3 = 0; n3 < 4; ++n3) {
                    d = dArray3[n2][n3];
                    dArray3[n2][n3] = dArray3[n4][n3];
                    dArray3[n4][n3] = d;
                    d = dArray2[n2 * 4 + n3];
                    dArray2[n2 * 4 + n3] = dArray2[n4 * 4 + n3];
                    dArray2[n4 * 4 + n3] = d;
                }
            }
            if (dArray3[n2][n2] == 0.0) {
                return false;
            }
            d = dArray3[n2][n2];
            for (n3 = 0; n3 < 4; ++n3) {
                double[] dArray4 = dArray3[n2];
                int n5 = n3;
                dArray4[n5] = dArray4[n5] / d;
                int n6 = n2 * 4 + n3;
                dArray2[n6] = dArray2[n6] / d;
            }
            for (n = 0; n < 4; ++n) {
                if (n == n2) continue;
                d = dArray3[n][n2];
                for (n3 = 0; n3 < 4; ++n3) {
                    double[] dArray5 = dArray3[n];
                    int n7 = n3;
                    dArray5[n7] = dArray5[n7] - dArray3[n2][n3] * d;
                    int n8 = n * 4 + n3;
                    dArray2[n8] = dArray2[n8] - dArray2[n2 * 4 + n3] * d;
                }
            }
        }
        return true;
    }

    private void __gluMultMatricesd(double[] dArray, double[] dArray2, double[] dArray3) {
        for (int i = 0; i < 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                dArray3[i * 4 + j] = dArray[i * 4 + 0] * dArray2[0 + j] + dArray[i * 4 + 1] * dArray2[4 + j] + dArray[i * 4 + 2] * dArray2[8 + j] + dArray[i * 4 + 3] * dArray2[12 + j];
            }
        }
    }

    private static void normalize(double[] dArray) {
        double d = Math.sqrt(dArray[0] * dArray[0] + dArray[1] * dArray[1] + dArray[2] * dArray[2]);
        if (d == 0.0) {
            return;
        }
        d = 1.0 / d;
        dArray[0] = dArray[0] * d;
        dArray[1] = dArray[1] * d;
        dArray[2] = dArray[2] * d;
    }

    private static void cross(double[] dArray, double[] dArray2, double[] dArray3) {
        dArray3[0] = dArray[1] * dArray2[2] - dArray[2] * dArray2[1];
        dArray3[1] = dArray[2] * dArray2[0] - dArray[0] * dArray2[2];
        dArray3[2] = dArray[0] * dArray2[1] - dArray[1] * dArray2[0];
    }

    public void gluOrtho2D(GL gL, double d, double d2, double d3, double d4) {
        gL.glOrtho(d, d2, d3, d4, -1.0, 1.0);
    }

    public void gluPerspective(GL gL, double d, double d2, double d3, double d4) {
        double d5 = d / 2.0 * Math.PI / 180.0;
        double d6 = d4 - d3;
        double d7 = Math.sin(d5);
        if (d6 == 0.0 || d7 == 0.0 || d2 == 0.0) {
            return;
        }
        double d8 = Math.cos(d5) / d7;
        this.__gluMakeIdentityd(this.matrix);
        this.matrix.put(0, d8 / d2);
        this.matrix.put(5, d8);
        this.matrix.put(10, -(d4 + d3) / d6);
        this.matrix.put(11, -1.0);
        this.matrix.put(14, -2.0 * d3 * d4 / d6);
        this.matrix.put(15, 0.0);
        gL.glMultMatrixd(this.matrix);
    }

    public void gluLookAt(GL gL, double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        double[] dArray = this.forward;
        double[] dArray2 = this.side;
        double[] dArray3 = this.up;
        dArray[0] = d4 - d;
        dArray[1] = d5 - d2;
        dArray[2] = d6 - d3;
        dArray3[0] = d7;
        dArray3[1] = d8;
        dArray3[2] = d9;
        Project.normalize(dArray);
        Project.cross(dArray, dArray3, dArray2);
        Project.normalize(dArray2);
        Project.cross(dArray2, dArray, dArray3);
        this.__gluMakeIdentityd(this.matrix);
        this.matrix.put(0, dArray2[0]);
        this.matrix.put(4, dArray2[1]);
        this.matrix.put(8, dArray2[2]);
        this.matrix.put(1, dArray3[0]);
        this.matrix.put(5, dArray3[1]);
        this.matrix.put(9, dArray3[2]);
        this.matrix.put(2, -dArray[0]);
        this.matrix.put(6, -dArray[1]);
        this.matrix.put(10, -dArray[2]);
        gL.glMultMatrixd(this.matrix);
        gL.glTranslated(-d, -d2, -d3);
    }

    public boolean gluProject(double d, double d2, double d3, double[] dArray, double[] dArray2, int[] nArray, double[] dArray3) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = 1.0;
        this.__gluMultMatrixVecd(dArray, dArray4, dArray5);
        this.__gluMultMatrixVecd(dArray2, dArray5, dArray4);
        if (dArray4[3] == 0.0) {
            return false;
        }
        dArray4[3] = 1.0 / dArray4[3] * 0.5;
        dArray4[0] = dArray4[0] * dArray4[3] + 0.5;
        dArray4[1] = dArray4[1] * dArray4[3] + 0.5;
        dArray4[2] = dArray4[2] * dArray4[3] + 0.5;
        dArray3[0] = dArray4[0] * (double)nArray[2] + (double)nArray[0];
        dArray3[1] = dArray4[1] * (double)nArray[3] + (double)nArray[1];
        dArray3[2] = dArray4[2];
        return true;
    }

    public boolean gluUnProject(double d, double d2, double d3, double[] dArray, double[] dArray2, int[] nArray, double[] dArray3) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, dArray2, this.finalMatrix);
        if (!this.__gluInvertMatrixd(this.finalMatrix, this.finalMatrix)) {
            return false;
        }
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = 1.0;
        dArray4[0] = (dArray4[0] - (double)nArray[0]) / (double)nArray[2];
        dArray4[1] = (dArray4[1] - (double)nArray[1]) / (double)nArray[3];
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.finalMatrix, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray5[3] = 1.0 / dArray5[3];
        dArray3[0] = dArray5[0] * dArray5[3];
        dArray3[1] = dArray5[1] * dArray5[3];
        dArray3[2] = dArray5[2] * dArray5[3];
        return true;
    }

    public boolean gluUnProject4(double d, double d2, double d3, double d4, double[] dArray, double[] dArray2, int[] nArray, double d5, double d6, double[] dArray3) {
        double[] dArray4 = this.in;
        double[] dArray5 = this.out;
        this.__gluMultMatricesd(dArray, dArray2, this.finalMatrix);
        if (!this.__gluInvertMatrixd(this.finalMatrix, this.finalMatrix)) {
            return false;
        }
        dArray4[0] = d;
        dArray4[1] = d2;
        dArray4[2] = d3;
        dArray4[3] = d4;
        dArray4[0] = (dArray4[0] - (double)nArray[0]) / (double)nArray[2];
        dArray4[1] = (dArray4[1] - (double)nArray[1]) / (double)nArray[3];
        dArray4[2] = (dArray4[2] - d5) / (d6 - d5);
        dArray4[0] = dArray4[0] * 2.0 - 1.0;
        dArray4[1] = dArray4[1] * 2.0 - 1.0;
        dArray4[2] = dArray4[2] * 2.0 - 1.0;
        this.__gluMultMatrixVecd(this.finalMatrix, dArray4, dArray5);
        if (dArray5[3] == 0.0) {
            return false;
        }
        dArray3[0] = dArray5[0];
        dArray3[1] = dArray5[1];
        dArray3[2] = dArray5[2];
        dArray3[3] = dArray5[3];
        return true;
    }

    public void gluPickMatrix(GL gL, double d, double d2, double d3, double d4, int[] nArray) {
        if (d3 <= 0.0 || d4 <= 0.0) {
            return;
        }
        gL.glTranslated(((double)nArray[2] - 2.0 * (d - (double)nArray[0])) / d3, ((double)nArray[3] - 2.0 * (d2 - (double)nArray[1])) / d4, 0.0);
        gL.glScaled((double)nArray[2] / d3, (double)nArray[3] / d4, 1.0);
    }
}

