/*
 * Created on Sep 9, 2005
 * Copyright 2005 Program of Computer Grpahics, Cornell University
 */
package resample.function;


/**
 * @see resample.function.FilterFunction for more information.
 * 
 * @author arbree
 * Sep 9, 2005
 * UnSharpFilter.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class UnSharpFilter extends FilterFunction {

  /**
   * The weight between the filters
   */
  protected double alpha = 0.5;

  /**
   * The cutoff of the Gaussian
   */
  protected double cutoff = 3.0;
  
  /**
   * The sigma of the Gaussian
   */
  protected double sigma = 1.0;
  
  /**
   * The width of the tent filter
   */
  protected double tentWidth = 0.1;
  
  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {

    return "Unsharp Filter";
    
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////////////////
  // Methods for the options panels
  ////////////////////////////////////////////////////////////////////////////////////////////////////
  
  /**
   * @see resample.function.FilterFunction#getOptionsFields()
   */
  protected String[] getOptionsFields() {

    return new String[] {"alpha", "cutoff", "sigma", "tentWidth"};
   
  }
}
