/*
 * Created on Sep 4, 2005
 * Copyright 2005 Program of Computer Grpahics, Cornell University
 */
package resample.function;


/**
 * @see resample.function.FilterFunction for more information.
 * 
 * @author Adam Arbree
 * Sep 4, 2005
 * GaussianFilter.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class GaussianFilter extends FilterFunction {

  /** The filter's standard deviation */
  protected double sigma = 1.0;
  
  /** The filter's cutoff in standard deviations */
  protected double cutoff = 3.0;
  
  /**
   * @see java.lang.Object#toString()
   */
  public String toString() {

    return "Gaussian Filter";
  }
  
  ////////////////////////////////////////////////////////////////////////////////////////////////////
  // Members related to options panel
  ////////////////////////////////////////////////////////////////////////////////////////////////////
  
  /** List of fields to go in options panel */
  private static final String[] optionsFields = new String[] {"sigma", "cutoff"};
  
  /**
   * @see resample.function.FilterFunction#getOptionsFields()
   */
  protected String[] getOptionsFields() {

    return optionsFields;
    
  }


}
