/*
 * Created on Sep 3, 2005
 * Copyright 2005 Program of Computer Grpahics, Cornell University
 */
package resample.function;

import resample.image.Image;
import resample.image.ResizableImage;


/**
 * Class that contains the basic filtering functions.  In general when filtering, assume
 * that all samples are located in the center of each pixel and that the image coordinates
 * (0,0) are the lower left hand corner of the image.
 * 
 * @author arbree
 * Sep 3, 2005
 * FilterOperations.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class FilterOperations extends DefaultFilterOperations {

  /** Temporary work image for separable filtering.  It is strongly suggested that 
   * you use this image for intermediate calculations because allocating new iamges 
   * for each filter operation will be quite costly.  You can just resize this image 
   * to whatever is needed and allocation is only performed when required. 
   */
  protected static final ResizableImage tempImage = new ResizableImage(512, 512);
  
  /**
   * The basic filtering routine.  This method should be written first and should
   * implement naive not seperable filtering.  The two arguments xSupportScale and ySupportScale
   * tell you the ratios between the input pixel spacing and filter canonical radius.  You will
   * need to multiply the results of filter.getSupport() to get the true filter size and you will
   * need to scale inputs to filter.evaluate() by the inverse of this value to get correct answers. 
   * 
   * @param input the input image
   * @param output the output image
   * @param xSupportScale the horizontal radius of the filter
   * @param ySupportScale the vertical radius of the filter
   * @param filter the fitlering function
   */
  public static final void filter(Image input, Image output, double xSupportScale, double ySupportScale, FilterFunction filter) {

    //TODO: Implement this method
    DefaultFilterOperations.filter(input, output, xSupportScale, ySupportScale, filter);
    
  }
  
  /**
   * Performs the same actions as filter, but will filter non-linear filters seperably.
   * 
   * @param input the input image
   * @param output the output image
   * @param xSupportScale the xSupport scale
   * @param ySupportScale the ySupport scale
   * @param filter the filter function
   */
  public static final void fastFilter(Image input, Image output, double xSupportScale, double ySupportScale, FilterFunction filter) {
    
    //TODO: Implement this method
    DefaultFilterOperations.fastFilter(input, output, xSupportScale, ySupportScale, filter);
    
  }
  
  /**
   * Resamples input to output using the filter function.  This method can be implemented using 
   * a call to filter() but you will have to calculate the correct support scale factors from the
   * sizes of the input and output images.
   * 
   * @param input the input image
   * @param output the output image
   * @param filter the filter function
   */
  public static final void resample(Image input, Image output, FilterFunction filter) {

    //TODO: Implement this method
    DefaultFilterOperations.resample(input, output, filter);
    
  }

  /**
   * Same as resample, but calls fastFilter.
   * 
   * @param input the input image
   * @param output the output image 
   * @param filter the filter function
   */
  public static final void fastResample(Image input, Image output, FilterFunction filter) {
  
    //TODO: Implement this method
    DefaultFilterOperations.resample(input, output, filter);
    
  }
}
