/*
 * Created on Jun 21, 2005
 * Copyright 2005 Program of Computer Grpahics, Cornell University
 */
package ray1.viewer;

import javax.swing.JFrame;

import ray1.misc.Image;


/**
 * @author arbree
 * Jun 21, 2005
 * QuickViewer.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class QuickViewer extends JFrame {

  /**
   * Internal panel used to display images
   */
  protected PanelDisplay imageDisplayPanel;

  /**
   * Constructor sets the close action of this frame
   */
  public QuickViewer() {

    setDefaultCloseOperation(JFrame.DISPOSE_ON_CLOSE);

  }

  /**
   * @see javax.swing.JFrame#frameInit()
   */
  protected void frameInit() {

    super.frameInit();
    imageDisplayPanel = new PanelDisplay(this);
    getContentPane().add(imageDisplayPanel);

  }

  /**
   * Sets the currently viewable image
   * @param inImage
   */
  public void setImage(Image inImage) {

    imageDisplayPanel.setImage(inImage);

  }

  /**
   * Starts the viewing
   */
  public void view() {

    pack();
    show();

  }

  /**
   * Updates the image view
   */
  public void update() {

    imageDisplayPanel.repaint();

  }

  /**
   * Creates a QuickViewer object for the current image, displays it and returns a reference to it.
   * @param inImage
   * @return the QiuckViewer object created
   */
  public static QuickViewer createImageViewer(Image inImage) {

    QuickViewer out = new QuickViewer();
    out.setImage(inImage);
    out.view();

    return out;

  }
}
