package ray1.surface;

import ray1.material.Material;
import ray1.math.Vector3;
import ray1.misc.IntersectionRecord;
import ray1.misc.Ray;

/**
 * A triangle is defined simply by 3 points.
 *
 * @author ags
 */
public class Triangle extends Surface {

  /** Material for this triangle * */
  protected Material material = Material.DEFAULT_MATERIAL;

  /** The first vertex. */
  public final Vector3 v0 = new Vector3();

  /** The second vertex. */
  public final Vector3 v1 = new Vector3(1,0,0);

  /** The third vertex. */
  public final Vector3 v2 = new Vector3(0,1,0);

  /**
   * Default contructor
   */
  public Triangle() {}

  /**
   * The explicit constructor. This is the only constructor with any real code
   * in it. Values should be set here, and any variables that need to be
   * calculated should be done here.
   *
   * @param newV0 The first vertex of the new triangle.
   * @param newV1 The second vertex of the new triangle.
   * @param newV2 The third vertex of the new triangle.
   * @param newMaterial The material of the new triangle.
   */
  public Triangle(Vector3 newV0, Vector3 newV1, Vector3 newV2, Material newMaterial) {

    material = newMaterial;
    v0.set(newV0);
    v1.set(newV1);
    v2.set(newV2);

  }

  /**
   * @param v0 The v0 to set.
   */
  public void setV0(Vector3 v0) {

    this.v0.set(v0);
  }

  /**
   * @param v1 The v1 to set.
   */
  public void setV1(Vector3 v1) {

    this.v1.set(v1);
  }

  /**
   * @param v2 The v2 to set.
   */
  public void setV2(Vector3 v2) {

    this.v2.set(v2);
  }

  /**
   * @see ray1.surface.Surface#getMaterial()
   */
  public Material getMaterial() {

    return material;
  }

  /**
   * @see ray1.surface.Surface#setMaterial(ray1.material.Material)
   */
  public void setMaterial(Material material) {

    this.material = material;

  }

  /**
   * @see Surface#intersect(IntersectionRecord, Ray)
   */
  public boolean intersect(IntersectionRecord outRecord, Ray ray) {

    return false;
    //TODO: Implement this method
    
  }

  /**
   * @see Object#toString()
   */
  public String toString() {

    return "triangle " + v0 + " " + v1 + " " + v2 + " " + material + " end";
  }
}