package ray1.surface;

import ray1.material.Material;
import ray1.misc.IntersectionRecord;
import ray1.misc.Ray;

/**
 * Abstract base class for all surfaces.  Provides access for material and
 * intersection uniformly for all surfaces.  Note that this class should not
 * contain a material pointer.  Material pointers are left under the control
 * of the implementation.  This allows very lightweight surfaces, for
 * example MeshTriangles which merely reference triangles in a TriangleMesh
 * surface, to share a material pointer.
 *
 * @author ags
 */
public abstract class Surface {

  /**
   * @return Returns the material.
   */
  public abstract Material getMaterial();

  /**
   * @param material The material to set.
   */
  public abstract void setMaterial(Material material);

  /**
   * Tests this surface for intersection with ray. If an intersection is found
   * record is filled out with the information about the intersection and the
   * method returns true. It returns false otherwise and the information in
   * outRecord is not modified.
   *
   * @param outRecord the output IntersectionRecord
   * @param ray the ray to intersect
   * @return true if the surface intersects the ray
   */

  public abstract boolean intersect(IntersectionRecord outRecord, Ray ray);

}