package ray1.surface;

import ray1.material.Material;
import ray1.math.Point3;
import ray1.math.Vector3;
import ray1.misc.IntersectionRecord;
import ray1.misc.Ray;

/**
 * Represents a sphere as a center and a radius.
 *
 * @author ags
 */
public class Sphere extends Surface {

  /** Material for this sphere. */
  protected Material material = Material.DEFAULT_MATERIAL;

  /** The center of the sphere. */
  protected final Point3 center = new Point3();

  /** The radius of the sphere. */
  protected double radius = 1.0;

  /**
   * Default constructor, creates a sphere at the origin with radius 1.0
   */
  public Sphere() {

  }

  /**
   * The explicit constructor. This is the only constructor with any real code
   * in it. Values should be set here, and any variables that need to be
   * calculated should be done here.
   *
   * @param newCenter The center of the new sphere.
   * @param newRadius The radius of the new sphere.
   * @param newMaterial The material of the new sphere.
   */
  public Sphere(Vector3 newCenter, double newRadius, Material newMaterial) {

    material = newMaterial;
    center.set(newCenter);
    radius = newRadius;
  }

  /**
   * @see ray1.surface.Surface#getMaterial()
   */
  public Material getMaterial() {

    return material;

  }

  /**
   * @see ray1.surface.Surface#setMaterial(ray1.material.Material)
   */
  public void setMaterial(Material material) {

    this.material = material;

  }

  /**
   * Returns the center of the sphere in the input Point3
   * @param outPoint output space
   */
  public void getCenter(Point3 outPoint) {

    outPoint.set(center);

  }

  /**
   * @param center The center to set.
   */
  public void setCenter(Point3 center) {

    this.center.set(center);

  }

  /**
   * @return Returns the radius.
   */
  public double getRadius() {

    return this.radius;
  }

  /**
   * @param radius The radius to set.
   */
  public void setRadius(double radius) {

    this.radius = radius;
  }

  /**
   * @see ray1.surface.Surface#intersect(ray1.misc.IntersectionRecord,
   *      ray1.misc.Ray)
   */
  public boolean intersect(IntersectionRecord outRecord, Ray ray) {

    return false;
    //TODO: Implement this method.
    
  }

  /**
   * @see Object#toString()
   */
  public String toString() {

    return "sphere " + center + " " + radius + " " + material + " end";
  }

}