/*
 * Created on Aug 19, 2005 Copyright 2005 Program of Computer Grpahics, Cornell
 * University
 */
package ray1.surface;

import ray1.material.Material;
import ray1.misc.IntersectionRecord;
import ray1.misc.Ray;
import ray1.surface.Surface;

/**
 * Represents an individual triangle in a mesh.
 * @author arbree Aug 19, 2005
 * MeshTriangle.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class MeshTriangle extends Surface {

  /** Pointer to the mesh containing this triangle * */
  protected Mesh mesh;

  /** The first triangle vertex * */
  protected int v0;

  /** The second triangle vertex * */
  protected int v1;

  /** The third triangle vertex * */
  protected int v2;

  /**
   * Protected constructor, only TriangleMesh objects should create
   * MeshTriangles. Just sets the input parameters.
   *
   * @param parentMesh
   * @param inV0
   * @param inV1
   * @param inV2
   */
  protected MeshTriangle(Mesh parentMesh, int inV0, int inV1, int inV2) {

    mesh = parentMesh;
    v0 = inV0;
    v1 = inV1;
    v2 = inV2;

  }

  /**
   * @see ray1.surface.Surface#getMaterial()
   */
  public Material getMaterial() {

    return mesh.material;

  }

  /**
   * @see ray1.surface.Surface#setMaterial(ray1.material.Material)
   */
  public void setMaterial(Material material) {

    throw new Error("The material for a individual triangle in a Mesh cannot be set, set the material in the mesh object.");

  }

  /**
   * @see ray1.surface.Surface#intersect(ray1.misc.IntersectionRecord,
   *      ray1.misc.Ray)
   */
  public boolean intersect(IntersectionRecord outRecord, Ray ray) {

    return false;
    //TODO: Implement this method
    
  }

}
