package ray1.misc;

import java.util.ArrayList;

import ray1.camera.Camera;
import ray1.lights.Light;
import ray1.material.Material;
import ray1.surface.Mesh;
import ray1.surface.MeshTriangle;
import ray1.surface.Surface;


/**
 * The scene is just a collection of objects that compose a scene. The camera,
 * lights, surfaces, materials and the output image.
 *
 * @author ags
 */
public class Scene {

  /** The camera for this scene. */
  protected Camera camera;

  /** The list of lights for the scene. */
  protected ArrayList lights = new ArrayList();

  /** The list of surfaces for the scene. */
  protected ArrayList surfaces = new ArrayList();

  /** The list of materials in the scene . */
  protected ArrayList materials = new ArrayList();

  /** Image to be produced by the renderer **/
  protected Image outputImage;

  /**
   * Work space for an intersection record needed in the
   * getFirstIntersctionMethod(). Avoids creating a new record each ray cast,
   * but not thread safe.
   */
  private IntersectionRecord workRec = new IntersectionRecord();

  /**
   * @return Returns the lights.
   */
  public ArrayList getLights() {

    return this.lights;
  }

  /**
   * @return Returns the outputImage.
   */
  public Image getImage() {

    return this.outputImage;
  }

  /**
   * @param outputImage The outputImage to set.
   */
  public void setImage(Image outputImage) {

    this.outputImage = outputImage;
  }

  /**
   * @return Returns the camera.
   */
  public Camera getCamera() {

    return this.camera;
  }



  /**
   * @param camera The camera to set.
   */
  public void setCamera(Camera camera) {

    this.camera = camera;
  }


  /**
   * Adds a light to the list of lights in the scene.
   *
   * @param toAdd The light to add to the scene.
   */
  public void addLight(Light toAdd) {

    lights.add(toAdd);
  }

  /**
   * Adds a surface to the list of surfaces in the scene.
   *
   * @param toAdd The surface to add to the scene.
   */
  public void addSurface(Surface toAdd) {

    //Add the individual triangles of a mesh
    if(toAdd instanceof Mesh) {

      MeshTriangle[] triangles = ((Mesh) toAdd).getTriangles();
      for (int i = 0; i < triangles.length; i++) {
        surfaces.add(triangles[i]);
      }
    }
    else surfaces.add(toAdd);
  }

  /**
   * Adds a material to the list of materials in the scene.
   *
   * @param toAdd the material to add
   */
  public void addMaterial(Material toAdd) {

    materials.add(toAdd);

  }
}