package ray1.material;

import ray1.math.Vector3;
import ray1.misc.Color;
import ray1.misc.IntersectionRecord;

/**
 * This interface specifies what is necessary for an object to be a material.
 * The shade method is pretty obvious - a material should know how to "color"
 * itself.  The copy method is needed so that a deep copy may be performed by
 * Surface objects, which all have a generic reference to a material.
 * @author ags
 */
public interface Material {

  /**
   * The material given to all surfaces unless another is specified.
   */
  public static final Material DEFAULT_MATERIAL = new Lambertian();

  /**
   * Calculate the BRDF value for this material at the intersection described in record.
   * Returns the BRDF color in outColor.
   * @param outColor Space for the output color
   * @param toLight Vector pointing towards the light
   * @param toEye Vector pointing towards the eye
   * @param record The intersection record, which hold the location, normal, etc.
   */
  public abstract void shade(Color outColor, Vector3 toLight, Vector3 toEye, IntersectionRecord record);

}