package ray1.material;

import ray1.math.Vector3;
import ray1.misc.Color;
import ray1.misc.IntersectionRecord;

/**
 * A Lambertian material scatters light equally in all directions. BRDF value is
 * a constant
 *
 * @author ags
 */
public class Lambertian implements Material {

  /** The color of the material represented. */
  protected final Color diffuseColor = new Color(1, 1, 1);

  /**
   * Defaults constructor creates a white lambertian material.
   */
  public Lambertian() {

  }

  /**
   * The explicit constructor. This is the only constructor with any real code
   * in it. Values should be set here, and any variables that need to be
   * calculated should be done here.
   *
   * @param inDiffuseColor The color of the new lambertian material.
   */
  public Lambertian(Color inDiffuseColor) {

    diffuseColor.set(inDiffuseColor);
  }

  /**
   * Returns rho in the given color
   *
   * @param outColor output space
   */
  public void getDiffuseColor(Color outColor) {

    outColor.set(diffuseColor);

  }

  /**
   * Sets rho to the input value
   *
   * @param inDiffuseColor the new diffuse color
   */
  public void setDiffuseColor(Color inDiffuseColor) {

    diffuseColor.set(inDiffuseColor);

  }

  /**
   * @see ray1.material.Material#shade(ray1.misc.Color, ray1.math.Vector3,
   *      ray1.math.Vector3, ray1.misc.IntersectionRecord)
   */
  public void shade(Color outColor, Vector3 toLight, Vector3 toEye, IntersectionRecord record) {

    //TODO: Implement this method

  }

  /**
   * @see Object#toString()
   */
  public String toString() {

    return "lambertian: " + diffuseColor;
  }

}