package ray1.lights;

import ray1.math.Point3;
import ray1.misc.Color;

/**
 * This class represents a basic point light which is infinitely small and emits
 * a constant power in all directions. This is a useful idealization of a small
 * light emitter.
 *
 * @author ags
 */
public class Light {

  /** The location of the light. */
  public final Point3 location = new Point3();

  /** The power of the light. */
  public final Color power = new Color(1, 1, 1);

  /**
   * Default constructor, assumes light has default values.
   */
  public Light() {

  }

  /**
   * Basic constructor sets the values of location and power.
   *
   * @param newLocation The location of the new light.
   * @param newPower The power of the new light.
   */
  public Light(Point3 newLocation, Color newPower) {

    location.set(newLocation);
    power.set(newPower);

  }

  /**
   * Returns the location of this light in outVector
   *
   * @param outVector output space
   */
  public void getLocation(Point3 outVector) {

    outVector.set(location);

  }

  /**
   * Sets the location of the light
   *
   * @param inLocation the input location
   */
  public void setLocation(Point3 inLocation) {

    location.set(inLocation);

  }

  /**
   * Returns the color of this light in outColor
   *
   * @param outColor output space
   */
  public void getPower(Color outColor) {

    outColor.set(power);

  }

  /**
   * Sets the power of the light
   *
   * @param inPower the input power
   */
  public void setPower(Color inPower) {

    power.set(inPower);

  }

  /**
   * @see Object#toString()
   */
  public String toString() {

    return "light: " + location + " " + power;

  }
}