package pipeline.misc;

/**
 * @author Beowulf
 */
public class Fragment {

  /** The screen space x coordinate of this fragment. */
  public int x;

  /** The screen space y coordinate of this fragment. */
  public int y;

  /** The attributes associated with this fragment. */
  public float[] attrs;

  /**
   * Creates an empty fragment
   */
  public Fragment() { }

  /**
   * Sets the data in this object to the input data
   * @param newX
   * @param newY
   * @param data
   */
  public void set(int newX, int newY, float[] data) {
    
    //Grow the data array if necessary
    int newSize = data.length;
    if(attrs == null || attrs.length < newSize)
      attrs = new float[newSize];
    
    //Set the data
    x = newX;
    y = newY;
    System.arraycopy(data, 0, attrs, 0, newSize);
    
  }
  
  /**
   * Sets the number of attributes that the fragment should store.
   * 
   * @param n The number of attributes to store.
   */
  public void setAttrs(int n) {

    if (attrs != null && n == attrs.length)
      return;
    attrs = new float[n];
  }

}
