/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.x11;

import java.awt.Component;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.FunctionAvailabilityCache;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.GLContextShareSet;
import net.java.games.jogl.impl.JAWT;
import net.java.games.jogl.impl.x11.GLProcAddressTable;
import net.java.games.jogl.impl.x11.GLX;
import net.java.games.jogl.impl.x11.X11GLContextFactory;
import net.java.games.jogl.impl.x11.X11GLImpl;
import net.java.games.jogl.impl.x11.XVisualInfo;

public abstract class X11GLContext
extends GLContext {
    protected long display;
    protected long drawable;
    protected long visualID;
    protected long context;
    private boolean glXQueryExtensionsStringInitialized;
    private boolean glXQueryExtensionsStringAvailable;
    private static final Map functionNameMap;
    private boolean isGLX13;
    private GLProcAddressTable glProcAddressTable;
    private static boolean haveResetGLXProcAddressTable;
    protected long mostRecentDisplay;
    protected static boolean isLinuxAMD64;
    static final /* synthetic */ boolean $assertionsDisabled;

    public X11GLContext(Component component, GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(component, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new X11GLImpl(this);
    }

    protected String mapToRealGLFunctionName(String string) {
        String string2 = (String)functionNameMap.get(string);
        if (string2 != null) {
            return string2;
        }
        return string;
    }

    protected String mapToRealGLExtensionName(String string) {
        return string;
    }

    protected abstract boolean isOffscreen();

    public int getOffscreenContextWidth() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextHeight() {
        throw new GLException("Should not call this");
    }

    public int getOffscreenContextPixelDataType() {
        throw new GLException("Should not call this");
    }

    public abstract int getOffscreenContextReadBuffer();

    public abstract boolean offscreenImageNeedsVerticalFlip();

    public synchronized void setRenderingThread(Thread thread, Runnable runnable) {
        this.willSetRenderingThread = false;
    }

    protected abstract void create();

    public boolean isExtensionAvailable(String string) {
        if (string.equals("GL_ARB_pbuffer") || string.equals("GL_ARB_pixel_format")) {
            return this.isGLX13;
        }
        return super.isExtensionAvailable(string);
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        boolean bl = false;
        if (this.context == 0L) {
            this.create();
            if (DEBUG) {
                System.err.println("!!! Created GL context for " + this.getClass().getName());
            }
            bl = true;
        }
        if (this.drawable == 0L) {
            throw new GLException("Unable to make context current; drawable was null");
        }
        if (!GLX.glXMakeCurrent(this.display, (int)this.drawable, this.context)) {
            throw new GLException("Error making context current");
        }
        if (bl) {
            this.resetGLFunctionAvailability();
            runnable.run();
        }
        return true;
    }

    protected synchronized void free() throws GLException {
        if (!GLX.glXMakeCurrent(this.display, 0L, 0L)) {
            throw new GLException("Error freeing OpenGL context");
        }
    }

    protected void destroyImpl() throws GLException {
        this.lockAWT();
        if (this.context != 0L) {
            GLX.glXDestroyContext(this.mostRecentDisplay, this.context);
            if (DEBUG) {
                System.err.println("!!! Destroyed OpenGL context " + this.context);
            }
            this.context = 0L;
        }
        this.unlockAWT();
    }

    public abstract void swapBuffers() throws GLException;

    protected long dynamicLookupFunction(String string) {
        long l = 0L;
        if (!isLinuxAMD64) {
            l = GLX.glXGetProcAddressARB(string);
        }
        if (l == 0L) {
            l = GLX.dlsym(string);
        }
        return l;
    }

    public boolean isCreated() {
        return this.context != 0L;
    }

    protected void resetGLFunctionAvailability() {
        GL gL;
        String string;
        super.resetGLFunctionAvailability();
        if (DEBUG) {
            System.err.println("!!! Initializing OpenGL extension address table");
        }
        this.resetProcAddressTable(this.getGLProcAddressTable());
        if (!haveResetGLXProcAddressTable) {
            this.resetProcAddressTable(GLX.getGLXProcAddressTable());
        }
        if (this.display == 0L) {
            throw new GLException("Expected non-null DISPLAY for querying GLX version");
        }
        int[] nArray = new int[1];
        int[] nArray2 = new int[1];
        if (!GLX.glXQueryVersion(this.display, nArray, nArray2)) {
            throw new GLException("glXQueryVersion failed");
        }
        if (DEBUG) {
            System.err.println("!!! GLX version: major " + nArray[0] + ", minor " + nArray2[0]);
        }
        if (nArray[0] == 1 && nArray2[0] == 2 && (string = (gL = this.getGL()).glGetString(7936)) != null && string.indexOf("ATI") >= 0) {
            this.isGLX13 = true;
            return;
        }
        this.isGLX13 = nArray[0] > 1 || nArray2[0] > 2;
    }

    public GLProcAddressTable getGLProcAddressTable() {
        if (this.glProcAddressTable == null) {
            this.glProcAddressTable = new GLProcAddressTable();
        }
        return this.glProcAddressTable;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized String getPlatformExtensionsString() {
        if (this.display == 0L) {
            throw new GLException("Context not current");
        }
        if (!this.glXQueryExtensionsStringInitialized) {
            this.glXQueryExtensionsStringAvailable = this.dynamicLookupFunction("glXQueryExtensionsString") != 0L;
            this.glXQueryExtensionsStringInitialized = true;
        }
        if (this.glXQueryExtensionsStringAvailable) {
            this.lockAWT();
            try {
                String string = GLX.glXQueryExtensionsString(this.display, GLX.DefaultScreen(this.display));
                if (DEBUG) {
                    System.err.println("!!! GLX extensions: " + string);
                }
                String string2 = string;
                return string2;
            }
            finally {
                this.unlockAWT();
            }
        }
        return "";
    }

    protected boolean isFunctionAvailable(String string) {
        boolean bl = super.isFunctionAvailable(string);
        if (!$assertionsDisabled && bl && this.getGLProcAddressTable().getAddressFor(this.mapToRealGLFunctionName(string)) == 0L && !FunctionAvailabilityCache.isPartOfGLCore("1.1", this.mapToRealGLFunctionName(string))) {
            throw new AssertionError();
        }
        return bl;
    }

    protected JAWT getJAWT() {
        return X11GLContextFactory.getJAWT();
    }

    protected XVisualInfo chooseVisual() {
        int n;
        if (!this.isOffscreen()) {
            int[] nArray = new int[1];
            XVisualInfo xVisualInfo = new XVisualInfo();
            xVisualInfo.visualid((int)this.visualID);
            XVisualInfo[] xVisualInfoArray = GLX.XGetVisualInfo(this.display, 1, xVisualInfo, nArray);
            if (xVisualInfoArray == null || xVisualInfoArray.length == 0) {
                throw new GLException("Error while getting XVisualInfo for visual ID " + this.visualID);
            }
            return xVisualInfoArray[0];
        }
        int n2 = 0;
        XVisualInfo xVisualInfo = null;
        int[] nArray = new int[1];
        XVisualInfo xVisualInfo2 = new XVisualInfo();
        xVisualInfo2.screen(n2);
        XVisualInfo[] xVisualInfoArray = GLX.XGetVisualInfo(this.display, 2, xVisualInfo2, nArray);
        if (xVisualInfoArray == null) {
            throw new GLException("Error while enumerating available XVisualInfos");
        }
        GLCapabilities[] gLCapabilitiesArray = new GLCapabilities[xVisualInfoArray.length];
        for (n = 0; n < xVisualInfoArray.length; ++n) {
            gLCapabilitiesArray[n] = X11GLContextFactory.xvi2GLCapabilities(this.display, xVisualInfoArray[n]);
        }
        n = this.chooser.chooseCapabilities(this.capabilities, gLCapabilitiesArray, -1);
        if (n < 0 || n >= gLCapabilitiesArray.length) {
            throw new GLException("GLCapabilitiesChooser specified invalid index (expected 0.." + (gLCapabilitiesArray.length - 1) + ")");
        }
        if (DEBUG) {
            System.err.println("Chosen visual (" + n + "):");
            System.err.println(gLCapabilitiesArray[n]);
        }
        if ((xVisualInfo = xVisualInfoArray[n]) == null) {
            throw new GLException("GLCapabilitiesChooser chose an invalid visual");
        }
        return xVisualInfo;
    }

    protected long createContext(XVisualInfo xVisualInfo, boolean bl) {
        X11GLContext x11GLContext = (X11GLContext)GLContextShareSet.getShareContext(this);
        long l = 0L;
        if (x11GLContext != null && (l = x11GLContext.getContext()) == 0L) {
            throw new GLException("GLContextShareSet returned an invalid OpenGL context");
        }
        long l2 = GLX.glXCreateContext(this.display, xVisualInfo, l, bl);
        if (l2 != 0L) {
            GLContextShareSet.contextCreated(this);
        }
        return l2;
    }

    protected void chooseVisualAndCreateContext(boolean bl) {
        XVisualInfo xVisualInfo = this.chooseVisual();
        this.context = this.createContext(xVisualInfo, bl);
        if (this.context == 0L) {
            throw new GLException("Unable to create OpenGL context");
        }
    }

    protected long getContext() {
        return this.context;
    }

    protected void lockAWT() {
        X11GLContextFactory.lockAWT();
    }

    protected void unlockAWT() {
        X11GLContextFactory.unlockAWT();
    }

    static {
        $assertionsDisabled = !X11GLContext.class.desiredAssertionStatus();
        functionNameMap = new HashMap();
        functionNameMap.put("glAllocateMemoryNV", "glXAllocateMemoryNV");
        functionNameMap.put("glFreeMemoryNV", "glXFreeMemoryNV");
        AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                String string = System.getProperty("os.name").toLowerCase();
                String string2 = System.getProperty("os.arch").toLowerCase();
                if (string.startsWith("linux") && string2.equals("amd64")) {
                    isLinuxAMD64 = true;
                }
                return null;
            }
        });
    }
}

