/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.windows;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLCapabilitiesChooser;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.windows.BITMAPINFO;
import net.java.games.jogl.impl.windows.BITMAPINFOHEADER;
import net.java.games.jogl.impl.windows.WGL;
import net.java.games.jogl.impl.windows.WindowsGLContext;
import net.java.games.jogl.impl.windows.WindowsGLImpl;

public class WindowsOffscreenGLContext
extends WindowsGLContext {
    private long origbitmap;
    private long hbitmap;
    private int width;
    private int height;

    public WindowsOffscreenGLContext(GLCapabilities gLCapabilities, GLCapabilitiesChooser gLCapabilitiesChooser, GLContext gLContext) {
        super(null, gLCapabilities, gLCapabilitiesChooser, gLContext);
    }

    protected GL createGL() {
        return new WindowsGLImpl(this);
    }

    protected boolean isOffscreen() {
        return true;
    }

    public int getOffscreenContextWidth() {
        return this.width;
    }

    public int getOffscreenContextHeight() {
        return this.height;
    }

    public int getOffscreenContextPixelDataType() {
        return 5121;
    }

    public int getOffscreenContextReadBuffer() {
        return 1028;
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        return false;
    }

    public boolean canCreatePbufferContext() {
        return false;
    }

    public synchronized GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    public void bindPbufferToTexture() {
        throw new GLException("Should not call this");
    }

    public void releasePbufferFromTexture() {
        throw new GLException("Should not call this");
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        if (this.pendingOffscreenResize && (this.pendingOffscreenWidth != this.width || this.pendingOffscreenHeight != this.height)) {
            if (this.hglrc != 0L) {
                this.destroyImpl();
            }
            this.width = this.pendingOffscreenWidth;
            this.height = this.pendingOffscreenHeight;
            this.pendingOffscreenResize = false;
        }
        return super.makeCurrent(runnable);
    }

    protected void destroyImpl() {
        if (this.hglrc != 0L) {
            super.destroyImpl();
            WGL.SelectObject(this.hdc, this.origbitmap);
            WGL.DeleteObject(this.hbitmap);
            WGL.DeleteDC(this.hdc);
            this.origbitmap = 0L;
            this.hbitmap = 0L;
            this.hdc = 0L;
        }
    }

    public synchronized void swapBuffers() throws GLException {
    }

    protected void create() {
        BITMAPINFO bITMAPINFO = new BITMAPINFO();
        BITMAPINFOHEADER bITMAPINFOHEADER = bITMAPINFO.bmiHeader();
        int n = this.capabilities.getRedBits() + this.capabilities.getGreenBits() + this.capabilities.getBlueBits();
        bITMAPINFOHEADER.biSize(bITMAPINFOHEADER.size());
        bITMAPINFOHEADER.biWidth(this.width);
        bITMAPINFOHEADER.biHeight(-1 * this.height);
        bITMAPINFOHEADER.biPlanes((short)1);
        bITMAPINFOHEADER.biBitCount((short)n);
        bITMAPINFOHEADER.biXPelsPerMeter(0);
        bITMAPINFOHEADER.biYPelsPerMeter(0);
        bITMAPINFOHEADER.biClrUsed(0);
        bITMAPINFOHEADER.biClrImportant(0);
        bITMAPINFOHEADER.biCompression(0);
        bITMAPINFOHEADER.biSizeImage(this.width * this.height * n / 8);
        this.hdc = WGL.CreateCompatibleDC(0L);
        if (this.hdc == 0L) {
            System.out.println("LastError: " + WGL.GetLastError());
            throw new GLException("Error creating device context for offscreen OpenGL context");
        }
        this.hbitmap = WGL.CreateDIBSection(this.hdc, bITMAPINFO, 0, 0L, 0L, 0);
        if (this.hbitmap == 0L) {
            throw new GLException("Error creating offscreen bitmap of width " + this.width + ", height " + this.height);
        }
        this.origbitmap = WGL.SelectObject(this.hdc, this.hbitmap);
        if (this.origbitmap == 0L) {
            throw new GLException("Error selecting bitmap into new device context");
        }
        this.choosePixelFormatAndCreateContext(false);
    }
}

