/*
 * Decompiled with CFR 0.152.
 */
package javax.vecmath;

import java.io.Serializable;
import javax.vecmath.GMatrix;
import javax.vecmath.MismatchedSizeException;
import javax.vecmath.Tuple2f;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple3f;
import javax.vecmath.Tuple4d;
import javax.vecmath.Tuple4f;
import javax.vecmath.VecMathI18N;

public class GVector
implements Serializable {
    private int length;
    double[] values;
    static final long serialVersionUID = 1398850036893875112L;

    public GVector(int n) {
        this.length = n;
        this.values = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.values[n2] = 0.0;
            ++n2;
        }
    }

    public GVector(GVector gVector) {
        this.values = new double[gVector.length];
        this.length = gVector.length;
        int n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n];
            ++n;
        }
    }

    public GVector(Tuple2f tuple2f) {
        this.values = new double[2];
        this.values[0] = tuple2f.x;
        this.values[1] = tuple2f.y;
        this.length = 2;
    }

    public GVector(Tuple3d tuple3d) {
        this.values = new double[3];
        this.values[0] = tuple3d.x;
        this.values[1] = tuple3d.y;
        this.values[2] = tuple3d.z;
        this.length = 3;
    }

    public GVector(Tuple3f tuple3f) {
        this.values = new double[3];
        this.values[0] = tuple3f.x;
        this.values[1] = tuple3f.y;
        this.values[2] = tuple3f.z;
        this.length = 3;
    }

    public GVector(Tuple4d tuple4d) {
        this.values = new double[4];
        this.values[0] = tuple4d.x;
        this.values[1] = tuple4d.y;
        this.values[2] = tuple4d.z;
        this.values[3] = tuple4d.w;
        this.length = 4;
    }

    public GVector(Tuple4f tuple4f) {
        this.values = new double[4];
        this.values[0] = tuple4f.x;
        this.values[1] = tuple4f.y;
        this.values[2] = tuple4f.z;
        this.values[3] = tuple4f.w;
        this.length = 4;
    }

    public GVector(double[] dArray) {
        this.length = dArray.length;
        this.values = new double[dArray.length];
        int n = 0;
        while (n < this.length) {
            this.values[n] = dArray[n];
            ++n;
        }
    }

    public GVector(double[] dArray, int n) {
        this.length = n;
        this.values = new double[n];
        int n2 = 0;
        while (n2 < n) {
            this.values[n2] = dArray[n2];
            ++n2;
        }
    }

    public final void LUDBackSolve(GMatrix gMatrix, GVector gVector, GVector gVector2) {
        int n = gMatrix.nRow * gMatrix.nCol;
        double[] dArray = new double[n];
        double[] dArray2 = new double[n];
        int[] nArray = new int[gVector.getSize()];
        if (gMatrix.nRow != gVector.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector16"));
        }
        if (gMatrix.nRow != gVector2.getSize()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector24"));
        }
        if (gMatrix.nRow != gMatrix.nCol) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector25"));
        }
        int n2 = 0;
        while (n2 < gMatrix.nRow) {
            int n3 = 0;
            while (n3 < gMatrix.nCol) {
                dArray[n2 * gMatrix.nCol + n3] = gMatrix.values[n2][n3];
                ++n3;
            }
            ++n2;
        }
        n2 = 0;
        while (n2 < n) {
            dArray2[n2] = 0.0;
            ++n2;
        }
        n2 = 0;
        while (n2 < gMatrix.nRow) {
            dArray2[n2 * gMatrix.nCol] = gVector.values[n2];
            ++n2;
        }
        n2 = 0;
        while (n2 < gMatrix.nCol) {
            nArray[n2] = (int)gVector2.values[n2];
            ++n2;
        }
        GMatrix.luBacksubstitution(gMatrix.nRow, dArray, nArray, dArray2);
        n2 = 0;
        while (n2 < gMatrix.nRow) {
            this.values[n2] = dArray2[n2 * gMatrix.nCol];
            ++n2;
        }
    }

    public final void SVDBackSolve(GMatrix gMatrix, GMatrix gMatrix2, GMatrix gMatrix3, GVector gVector) {
        if (gMatrix.nRow != gVector.getSize() || gMatrix.nRow != gMatrix.nCol || gMatrix.nRow != gMatrix2.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector15"));
        }
        if (gMatrix2.nCol != this.values.length || gMatrix2.nCol != gMatrix3.nCol || gMatrix2.nCol != gMatrix3.nRow) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector23"));
        }
        GMatrix gMatrix4 = new GMatrix(gMatrix.nRow, gMatrix2.nCol);
        gMatrix4.mul(gMatrix, gMatrix3);
        gMatrix4.mulTransposeRight(gMatrix, gMatrix2);
        gMatrix4.invert();
        this.mul(gMatrix4, gVector);
    }

    public final void add(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector4"));
        }
        int n = 0;
        while (n < this.length) {
            int n2 = n;
            this.values[n2] = this.values[n2] + gVector.values[n];
            ++n;
        }
    }

    public final void add(GVector gVector, GVector gVector2) {
        if (gVector.length != gVector2.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector5"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector6"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n] + gVector2.values[n];
            ++n;
        }
    }

    public final double angle(GVector gVector) {
        return Math.acos(this.dot(gVector) / (this.norm() * gVector.norm()));
    }

    public final double dot(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector14"));
        }
        double d = 0.0;
        int n = 0;
        while (n < this.length) {
            d += this.values[n] * gVector.values[n];
            ++n;
        }
        return d;
    }

    public boolean epsilonEquals(GVector gVector, double d) {
        if (this.length != gVector.length) {
            return false;
        }
        int n = 0;
        while (n < this.length) {
            double d2 = this.values[n] - gVector.values[n];
            double d3 = d2 < 0.0 ? -d2 : d2;
            if (d3 > d) {
                return false;
            }
            ++n;
        }
        return true;
    }

    public boolean equals(Object object) {
        try {
            GVector gVector = (GVector)object;
            if (this.length != gVector.length) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.values[n] != gVector.values[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (ClassCastException classCastException) {
            return false;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public boolean equals(GVector gVector) {
        try {
            if (this.length != gVector.length) {
                return false;
            }
            int n = 0;
            while (n < this.length) {
                if (this.values[n] != gVector.values[n]) {
                    return false;
                }
                ++n;
            }
            return true;
        }
        catch (NullPointerException nullPointerException) {
            return false;
        }
    }

    public final double getElement(int n) {
        return this.values[n];
    }

    public final int getSize() {
        return this.values.length;
    }

    public int hashCode() {
        long l = 1L;
        int n = 0;
        while (n < this.length) {
            l = 31L * l + Double.doubleToLongBits(this.values[n]);
            ++n;
        }
        return (int)(l ^ l >> 32);
    }

    public final void interpolate(GVector gVector, double d) {
        if (gVector.length != this.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector22"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = (1.0 - d) * this.values[n] + d * gVector.values[n];
            ++n;
        }
    }

    public final void interpolate(GVector gVector, float f) {
        this.interpolate(gVector, (double)f);
    }

    public final void interpolate(GVector gVector, GVector gVector2, double d) {
        if (gVector2.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector20"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector21"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = (1.0 - d) * gVector.values[n] + d * gVector2.values[n];
            ++n;
        }
    }

    public final void interpolate(GVector gVector, GVector gVector2, float f) {
        this.interpolate(gVector, gVector2, (double)f);
    }

    public final void mul(GMatrix gMatrix, GVector gVector) {
        if (gMatrix.getNumCol() != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector10"));
        }
        if (this.length != gMatrix.getNumRow()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector11"));
        }
        double[] dArray = gVector != this ? gVector.values : (double[])this.values.clone();
        int n = this.length - 1;
        while (n >= 0) {
            this.values[n] = 0.0;
            int n2 = gVector.length - 1;
            while (n2 >= 0) {
                int n3 = n;
                this.values[n3] = this.values[n3] + gMatrix.values[n][n2] * dArray[n2];
                --n2;
            }
            --n;
        }
    }

    public final void mul(GVector gVector, GMatrix gMatrix) {
        if (gMatrix.getNumRow() != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector12"));
        }
        if (this.length != gMatrix.getNumCol()) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector13"));
        }
        double[] dArray = gVector != this ? gVector.values : (double[])this.values.clone();
        int n = this.length - 1;
        while (n >= 0) {
            this.values[n] = 0.0;
            int n2 = gVector.length - 1;
            while (n2 >= 0) {
                int n3 = n;
                this.values[n3] = this.values[n3] + gMatrix.values[n2][n] * dArray[n2];
                --n2;
            }
            --n;
        }
    }

    public final void negate() {
        int n = this.length - 1;
        while (n >= 0) {
            int n2 = n--;
            this.values[n2] = this.values[n2] * -1.0;
        }
    }

    public final double norm() {
        double d = 0.0;
        int n = 0;
        while (n < this.length) {
            d += this.values[n] * this.values[n];
            ++n;
        }
        return Math.sqrt(d);
    }

    public final double normSquared() {
        double d = 0.0;
        int n = 0;
        while (n < this.length) {
            d += this.values[n] * this.values[n];
            ++n;
        }
        return d;
    }

    public final void normalize() {
        double d = 0.0;
        int n = 0;
        while (n < this.length) {
            d += this.values[n] * this.values[n];
            ++n;
        }
        double d2 = 1.0 / Math.sqrt(d);
        n = 0;
        while (n < this.length) {
            this.values[n] = this.values[n] * d2;
            ++n;
        }
    }

    public final void normalize(GVector gVector) {
        double d = 0.0;
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector0"));
        }
        int n = 0;
        while (n < this.length) {
            d += gVector.values[n] * gVector.values[n];
            ++n;
        }
        double d2 = 1.0 / Math.sqrt(d);
        n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n] * d2;
            ++n;
        }
    }

    public final void scale(double d) {
        int n = 0;
        while (n < this.length) {
            this.values[n] = this.values[n] * d;
            ++n;
        }
    }

    public final void scale(double d, GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector1"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n] * d;
            ++n;
        }
    }

    public final void scaleAdd(double d, GVector gVector, GVector gVector2) {
        if (gVector2.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector2"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector3"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n] * d + gVector2.values[n];
            ++n;
        }
    }

    public final void set(GVector gVector) {
        if (this.length < gVector.length) {
            this.length = gVector.length;
            this.values = new double[this.length];
            int n = 0;
            while (n < this.length) {
                this.values[n] = gVector.values[n];
                ++n;
            }
        } else {
            int n = 0;
            while (n < gVector.length) {
                this.values[n] = gVector.values[n];
                ++n;
            }
            n = gVector.length;
            while (n < this.length) {
                this.values[n] = 0.0;
                ++n;
            }
        }
    }

    public final void set(Tuple2f tuple2f) {
        if (this.length < 2) {
            this.length = 2;
            this.values = new double[2];
        }
        this.values[0] = tuple2f.x;
        this.values[1] = tuple2f.y;
        int n = 2;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }

    public final void set(Tuple3d tuple3d) {
        if (this.length < 3) {
            this.length = 3;
            this.values = new double[3];
        }
        this.values[0] = tuple3d.x;
        this.values[1] = tuple3d.y;
        this.values[2] = tuple3d.z;
        int n = 3;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }

    public final void set(Tuple3f tuple3f) {
        if (this.length < 3) {
            this.length = 3;
            this.values = new double[3];
        }
        this.values[0] = tuple3f.x;
        this.values[1] = tuple3f.y;
        this.values[2] = tuple3f.z;
        int n = 3;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }

    public final void set(Tuple4d tuple4d) {
        if (this.length < 4) {
            this.length = 4;
            this.values = new double[4];
        }
        this.values[0] = tuple4d.x;
        this.values[1] = tuple4d.y;
        this.values[2] = tuple4d.z;
        this.values[3] = tuple4d.w;
        int n = 4;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }

    public final void set(Tuple4f tuple4f) {
        if (this.length < 4) {
            this.length = 4;
            this.values = new double[4];
        }
        this.values[0] = tuple4f.x;
        this.values[1] = tuple4f.y;
        this.values[2] = tuple4f.z;
        this.values[3] = tuple4f.w;
        int n = 4;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }

    public final void set(double[] dArray) {
        int n = this.length - 1;
        while (n >= 0) {
            this.values[n] = dArray[n];
            --n;
        }
    }

    public final void setElement(int n, double d) {
        this.values[n] = d;
    }

    public final void setSize(int n) {
        double[] dArray = new double[n];
        int n2 = this.length < n ? this.length : n;
        int n3 = 0;
        while (n3 < n2) {
            dArray[n3] = this.values[n3];
            ++n3;
        }
        this.length = n;
        this.values = dArray;
    }

    public final void sub(GVector gVector) {
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector7"));
        }
        int n = 0;
        while (n < this.length) {
            int n2 = n;
            this.values[n2] = this.values[n2] - gVector.values[n];
            ++n;
        }
    }

    public final void sub(GVector gVector, GVector gVector2) {
        if (gVector.length != gVector2.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector8"));
        }
        if (this.length != gVector.length) {
            throw new MismatchedSizeException(VecMathI18N.getString("GVector9"));
        }
        int n = 0;
        while (n < this.length) {
            this.values[n] = gVector.values[n] - gVector2.values[n];
            ++n;
        }
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(this.length * 8);
        int n = 0;
        while (n < this.length) {
            stringBuffer.append(this.values[n]).append(" ");
            ++n;
        }
        return stringBuffer.toString();
    }

    public final void zero() {
        int n = 0;
        while (n < this.length) {
            this.values[n] = 0.0;
            ++n;
        }
    }
}

