package modeler.shape;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import javax.vecmath.Point2f;

/**
 * @author ags
 */
public class BezierRotation extends Shape {

  private static final long serialVersionUID = 3256437006337718072L;
  
  /** This rotation's spline */
  protected BezierSpline spline;
  
  /**
   * Creates a Bezier rotation
   *
   */
  public BezierRotation() {

    spline = BezierSpline.createSpline(new Point2f(0,-1), new Point2f(1,-1), new Point2f(1,1), new Point2f(0,1));
    
  }

  /**
   * @see modeler.shape.Shape#buildMesh()
   */
  public void buildMesh() {

    //TODO:  Build mesh
    
  }

  /**
   * Returns this rotation's spline
   */
  public BezierSpline getSpline() {
    
    return spline;
    
  }
  
  /**
   * @see modeler.shape.Shape#readData(java.io.ObjectInputStream)
   */
  protected void readData(ObjectInputStream in) throws IOException {

    super.readData(in);
    BezierSpline.createSpline(null, null, null, null);
    spline.readData(in);
    
  }

  /**
   * @see modeler.shape.Shape#saveData(java.io.ObjectOutputStream)
   */
  protected void saveData(ObjectOutputStream out) throws IOException {

    super.saveData(out);
    spline.writeData(out);

  }

}