package modeler;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;

import javax.imageio.ImageIO;

import net.java.games.jogl.GL;

/**
 * This class holds all of the information necessary to describe texture data.
 * 
 * @author ags
 */
public class Texture {

  /** The name of the file from where the data was loaded */
  protected String filename;

  /** The width of the texture. */
  private int nx;

  /** The height of the texture. */
  private int ny;

  /** The RGB data for each pixel. */
  public byte[] cData;

  /**
   * Reads in a texture from the given file and stores the data. The image file
   * given must be stored in a format recognizable by javax.imageio.ImageIO.
   * 
   * @param imageFile The file where the texture is stored.
   * @throws IOException 
   */
  public Texture(File imageFile) throws IOException {

    BufferedImage loadedImage = ImageIO.read(imageFile);

    nx = loadedImage.getWidth();
    ny = loadedImage.getHeight();
    cData = new byte[nx * ny * 3];

    System.out.print("loading " + nx + " x " + ny + " texture...");
    filename = imageFile.getName();

    int offset = 0;
    for (int iy = 0; iy < ny; iy++) {
      for (int ix = 0; ix < nx; ix++) {
        int pixelValue = loadedImage.getRGB(ix, ny - 1 - iy);

        cData[offset + 0] = (byte) (0xff & (pixelValue >> 16));
        cData[offset + 1] = (byte) (0xff & (pixelValue >> 8));
        cData[offset + 2] = (byte) (0xff & (pixelValue >> 0));

        offset += 3;
      }
    }

    System.out.println("done.");
  }

  /**
   * Enable this texture
   * @param gl
   */
  public void enable(GL gl) {
    
    gl.glEnable(GL.GL_TEXTURE_2D);
    gl.glTexImage2D(GL.GL_TEXTURE_2D, 0, GL.GL_RGB, nx, ny, 0, GL.GL_RGB, GL.GL_UNSIGNED_BYTE, cData);
    
  }
  
}
