package modeler;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;

import javax.vecmath.Point3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

import net.java.games.jogl.GLDrawable;

/**
 * @author ags
 */
public class OrthoCamera extends Camera {

  private static final long serialVersionUID = 3256437006337718072L;
  
  protected static final int NEAR_PLANE = -50;
  protected static final int FAR_PLANE = 50;
  protected static final int START_HEIGHT = 3;
  
  /** The height of the camera image */
  protected float height = START_HEIGHT;
  
  /**
   * Required for IO
   *
   */
  public OrthoCamera() {}
  
  /**
   * Constructor
   * @param newEye
   * @param newTarget
   * @param newUp
   * @param newName
   */
  public OrthoCamera(Point3f newEye, Point3f newTarget, Vector3f newUp, String newName) {

    super(newEye, newTarget, newUp, NEAR_PLANE, FAR_PLANE, newName);
    updateFrame();

  }

  /**
   * @see modeler.Camera#getHeight()
   */
  public float getHeight() {

    return height;
  }

    /**
   * @see modeler.Camera#zoom(float)
   */
  public void zoom(float d) {

    height *= Math.pow(2, -d / 2);
  }

  /**
   * @see modeler.Camera#convertMotion(javax.vecmath.Vector2f, javax.vecmath.Vector3f)
   */
  public void convertMotion(Vector2f delta, Vector3f output) {
    output.scale(-delta.x * aspect * height, right);
    output.scaleAdd(-delta.y * height, up, output);
  }
  
  /**
   * @see modeler.Camera#doProjection(net.java.games.jogl.GLDrawable)
   */
  public void doProjection(GLDrawable d) {

    d.getGL().glOrtho(-height * aspect, height * aspect, -height, height, near, far);
  }
  

  /**
   * @see modeler.Treeable#getAttributePanel(modeler.MainFrame)
   */
  public ItemAttributePanel getAttributePanel(MainFrame mainFrame) {

    return ItemAttributePanel.EMPTY_PANEL;
  }

  
  /**
   * @see modeler.Camera#readData(java.io.ObjectInputStream)
   */
  protected void readData(ObjectInputStream in) throws IOException {

    super.readData(in);
    height = in.readFloat();
    
  }
  

  /**
   * @see modeler.Camera#saveData(java.io.ObjectOutputStream)
   */
  protected void saveData(ObjectOutputStream out) throws IOException {

    super.saveData(out);
    out.writeFloat(height);
    
  }
}
