/*
 * Decompiled with CFR 0.152.
 */
package net.java.games.jogl.impl.windows;

import net.java.games.jogl.GL;
import net.java.games.jogl.GLCapabilities;
import net.java.games.jogl.GLException;
import net.java.games.jogl.impl.Debug;
import net.java.games.jogl.impl.GLContext;
import net.java.games.jogl.impl.windows.WGL;
import net.java.games.jogl.impl.windows.WindowsGLContext;

public class WindowsPbufferGLContext
extends WindowsGLContext {
    private static final boolean DEBUG;
    private int initWidth;
    private int initHeight;
    private long buffer;
    private int width;
    private int height;
    private long parentHglrc;
    private static final int MAX_PFORMATS = 256;
    private static final int MAX_ATTRIBS = 256;
    private boolean created;
    private boolean rtt;
    private boolean hasRTT;
    private boolean rect;
    private int textureTarget;
    private int texture;
    private int floatMode;
    static final /* synthetic */ boolean $assertionsDisabled;

    public WindowsPbufferGLContext(GLCapabilities gLCapabilities, int n, int n2) {
        super(null, gLCapabilities, null, null);
        this.initWidth = n;
        this.initHeight = n2;
        if (this.initWidth <= 0 || this.initHeight <= 0) {
            throw new GLException("Initial width and height of pbuffer must be positive (were (" + this.initWidth + ", " + this.initHeight + "))");
        }
        if (DEBUG) {
            System.out.println("Pbuffer caps on init: " + gLCapabilities + (gLCapabilities.getOffscreenRenderToTexture() ? " [rtt]" : "") + (gLCapabilities.getOffscreenRenderToTextureRectangle() ? " [rect]" : "") + (gLCapabilities.getOffscreenFloatingPointBuffers() ? " [float]" : ""));
        }
    }

    public boolean canCreatePbufferContext() {
        return false;
    }

    public GLContext createPbufferContext(GLCapabilities gLCapabilities, int n, int n2) {
        throw new GLException("Not supported");
    }

    public void bindPbufferToTexture() {
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        GL gL = this.getGL();
        gL.glBindTexture(this.textureTarget, this.texture);
        if (this.rtt && this.hasRTT && !gL.wglBindTexImageARB(this.buffer, 8323)) {
            throw new GLException("Binding of pbuffer to texture failed: " + this.wglGetLastError());
        }
    }

    public void releasePbufferFromTexture() {
        GL gL;
        if (!this.rtt) {
            throw new GLException("Shouldn't try to bind a pbuffer to a texture if render-to-texture hasn't been specified in its GLCapabilities");
        }
        if (this.rtt && this.hasRTT && !(gL = this.getGL()).wglReleaseTexImageARB(this.buffer, 8323)) {
            throw new GLException("Releasing of pbuffer from texture failed: " + this.wglGetLastError());
        }
    }

    public void createPbuffer(long l, long l2) {
        int n;
        GL gL = this.getGL();
        this.resetGLFunctionAvailability();
        int[] nArray = new int[512];
        float[] fArray = new float[512];
        boolean bl = false;
        int n2 = 0;
        if (DEBUG) {
            System.out.println("Pbuffer caps: " + this.capabilities + (this.capabilities.getOffscreenRenderToTexture() ? " [rtt]" : "") + (this.capabilities.getOffscreenRenderToTextureRectangle() ? " [rect]" : "") + (this.capabilities.getOffscreenFloatingPointBuffers() ? " [float]" : ""));
        }
        this.rtt = this.capabilities.getOffscreenRenderToTexture();
        this.rect = this.capabilities.getOffscreenRenderToTextureRectangle();
        boolean bl2 = this.capabilities.getOffscreenFloatingPointBuffers();
        boolean bl3 = false;
        nArray[n2++] = 8237;
        nArray[n2++] = 1;
        if (this.rtt && !this.rect) {
            throw new GLException("Render-to-texture-rectangle requires render-to-texture to be specified");
        }
        if (this.rect && !gL.isExtensionAvailable("GL_NV_texture_rectangle")) {
            throw new GLException("Render-to-texture-rectangle requires GL_NV_texture_rectangle extension");
        }
        if (bl2) {
            if (!gL.isExtensionAvailable("WGL_ATI_pixel_format_float") && !gL.isExtensionAvailable("WGL_NV_float_buffer")) {
                throw new GLException("Floating-point pbuffers not supported by this hardware");
            }
            if (gL.isExtensionAvailable("WGL_NV_float_buffer")) {
                bl3 = false;
                this.floatMode = 3;
            } else {
                bl3 = true;
                this.floatMode = 2;
            }
            if (DEBUG) {
                System.err.println("Using " + (bl3 ? "ATI" : "NVidia") + " floating-point extension");
            }
        }
        if (bl2 && bl3) {
            if (this.rtt) {
                throw new GLException("Render-to-floating-point-texture not supported on ATI hardware");
            }
            nArray[n2++] = 8211;
            nArray[n2++] = 8608;
        } else if (!this.rtt) {
            nArray[n2++] = 8211;
            nArray[n2++] = 8235;
        }
        nArray[n2++] = 8209;
        nArray[n2++] = this.capabilities.getDoubleBuffered() ? 1 : 0;
        nArray[n2++] = 8226;
        nArray[n2++] = this.capabilities.getDepthBits();
        nArray[n2++] = 8213;
        nArray[n2++] = this.capabilities.getRedBits();
        nArray[n2++] = 8215;
        nArray[n2++] = this.capabilities.getGreenBits();
        nArray[n2++] = 8217;
        nArray[n2++] = this.capabilities.getBlueBits();
        nArray[n2++] = 8219;
        nArray[n2++] = this.capabilities.getAlphaBits();
        nArray[n2++] = 8227;
        nArray[n2++] = this.capabilities.getStencilBits() > 0 ? 1 : 0;
        if (this.capabilities.getAccumRedBits() > 0 || this.capabilities.getAccumGreenBits() > 0 || this.capabilities.getAccumBlueBits() > 0) {
            nArray[n2++] = 8221;
            nArray[n2++] = 1;
        }
        if (bl2 && !bl3) {
            nArray[n2++] = 8368;
            nArray[n2++] = 1;
        }
        if (this.rtt) {
            if (bl2) {
                if (!$assertionsDisabled && bl3) {
                    throw new AssertionError();
                }
                if (!this.rect) {
                    throw new GLException("Render-to-floating-point-texture only supported on NVidia hardware with render-to-texture-rectangle");
                }
                nArray[n2++] = 8371;
                nArray[n2++] = 1;
            } else {
                nArray[n2++] = this.rect ? 8352 : 8304;
                nArray[n2++] = 1;
            }
        }
        nArray[n2++] = 8208;
        nArray[n2++] = 1;
        int[] nArray2 = new int[256];
        int[] nArray3 = new int[1];
        if (!gL.wglChoosePixelFormatARB(l, nArray, fArray, 256, nArray2, nArray3)) {
            throw new GLException("pbuffer creation error: wglChoosePixelFormatARB() failed");
        }
        int n3 = nArray3[0];
        if (n3 <= 0) {
            throw new GLException("pbuffer creation error: Couldn't find a suitable pixel format");
        }
        if (DEBUG) {
            System.err.println("" + n3 + " suitable pixel formats found");
            nArray[0] = 8213;
            nArray[1] = 8215;
            nArray[2] = 8217;
            nArray[3] = 8219;
            nArray[4] = 8226;
            nArray[5] = bl2 ? (bl3 ? 8211 : 8368) : 8213;
            nArray[6] = 8257;
            nArray[7] = 8258;
            nArray[8] = 8237;
            int[] nArray4 = new int[9];
            for (int i = 0; i < n3; ++i) {
                if (!gL.wglGetPixelFormatAttribivARB(l, nArray2[i], 0, 9, nArray, nArray4)) {
                    throw new GLException("Error while querying pixel format " + nArray2[i] + "'s (index " + i + "'s) capabilities for debugging");
                }
                System.err.print("pixel format " + nArray2[i] + " (index " + i + "): ");
                System.err.print("r: " + nArray4[0]);
                System.err.print(" g: " + nArray4[1]);
                System.err.print(" b: " + nArray4[2]);
                System.err.print(" a: " + nArray4[3]);
                System.err.print(" depth: " + nArray4[4]);
                System.err.print(" multisample: " + nArray4[6]);
                System.err.print(" samples: " + nArray4[7]);
                if (bl2) {
                    if (bl3) {
                        if (nArray4[5] == 8608) {
                            System.err.print(" [ati float]");
                        } else if (nArray4[5] != 8235) {
                            System.err.print(" [unknown pixel type " + nArray4[5] + "]");
                        }
                    } else if (nArray4[5] != 0) {
                        System.err.print(" [float]");
                    }
                }
                if (nArray4[8] != 0) {
                    System.err.print(" [pbuffer]");
                }
                System.err.println();
            }
        }
        long l3 = 0L;
        int n4 = 0;
        do {
            n = nArray2[n4];
            n2 = 0;
            if (this.rtt) {
                nArray[n2++] = 8306;
                nArray[n2++] = bl2 ? 8375 : 8310;
                nArray[n2++] = 8307;
                nArray[n2++] = this.rect ? 8354 : 8314;
                nArray[n2++] = 8308;
                nArray[n2++] = 0;
                nArray[n2++] = 8243;
                nArray[n2++] = 0;
            }
            nArray[n2++] = 0;
        } while ((l3 = gL.wglCreatePbufferARB(l, n, this.initWidth, this.initHeight, nArray)) == 0L && ++n4 < n3);
        if (l3 == 0L) {
            throw new GLException("pbuffer creation error: wglCreatePbufferARB() failed: tried " + n3 + " pixel formats, last error was: " + this.wglGetLastError());
        }
        long l4 = gL.wglGetPbufferDCARB(l3);
        if (l4 == 0L) {
            throw new GLException("pbuffer creation error: wglGetPbufferDCARB() failed");
        }
        this.parentHglrc = l2;
        this.buffer = l3;
        this.hdc = l4;
        int[] nArray5 = new int[1];
        gL.wglQueryPbufferARB(this.buffer, 8244, nArray5);
        this.width = nArray5[0];
        gL.wglQueryPbufferARB(this.buffer, 8245, nArray5);
        this.height = nArray5[0];
        if (DEBUG) {
            System.err.println("Created pbuffer " + this.width + " x " + this.height);
        }
    }

    protected synchronized boolean makeCurrent(Runnable runnable) throws GLException {
        this.created = false;
        if (this.buffer == 0L) {
            if (DEBUG) {
                System.err.println("pbuffer not instantiated yet");
            }
            return false;
        }
        boolean bl = super.makeCurrent(runnable);
        if (DEBUG) {
            System.err.println("super.makeCurrent() = " + bl + ", created = " + this.created);
        }
        if (this.created) {
            this.rtt = this.capabilities.getOffscreenRenderToTexture();
            this.rect = this.capabilities.getOffscreenRenderToTextureRectangle();
            if (this.rtt) {
                if (DEBUG) {
                    System.err.println("Initializing render-to-texture support");
                }
                if (!this.gl.isExtensionAvailable("WGL_ARB_render_texture")) {
                    System.err.println("WindowsPbufferGLContext: WARNING: WGL_ARB_render_texture extension not supported; implementing render_to_texture support using slow texture readback");
                } else {
                    this.hasRTT = true;
                    GL gL = this.getGL();
                    if (this.rect && !gL.isExtensionAvailable("GL_NV_texture_rectangle")) {
                        System.err.println("WindowsPbufferGLContext: WARNING: GL_NV_texture_rectangle extension not supported; skipping requested render_to_texture_rectangle support for pbuffer");
                        this.rect = false;
                    }
                    if (this.rect) {
                        if (DEBUG) {
                            System.err.println("  Using render-to-texture-rectangle");
                        }
                        this.textureTarget = 34037;
                    } else {
                        if (DEBUG) {
                            System.err.println("  Using vanilla render-to-texture");
                        }
                        this.textureTarget = 3553;
                    }
                    int[] nArray = new int[1];
                    gL.glGenTextures(1, nArray);
                    this.texture = nArray[0];
                    gL.glBindTexture(this.textureTarget, this.texture);
                    gL.glTexParameteri(this.textureTarget, 10241, 9728);
                    gL.glTexParameteri(this.textureTarget, 10240, 9728);
                    gL.glTexParameteri(this.textureTarget, 10242, 33071);
                    gL.glTexParameteri(this.textureTarget, 10243, 33071);
                    gL.glCopyTexImage2D(this.textureTarget, 0, 6407, 0, 0, this.width, this.height, 0);
                }
            }
        }
        return bl;
    }

    public void handleModeSwitch(long l, long l2) {
        throw new GLException("Not yet implemented");
    }

    protected boolean isOffscreen() {
        return false;
    }

    public int getOffscreenContextReadBuffer() {
        throw new GLException("Should not call this");
    }

    public boolean offscreenImageNeedsVerticalFlip() {
        throw new GLException("Should not call this");
    }

    protected void create() {
        this.created = true;
        this.hglrc = WGL.wglCreateContext(this.hdc);
        if (this.hglrc == 0L) {
            throw new GLException("pbuffer creation error: wglCreateContext() failed");
        }
        if (!WGL.wglShareLists(this.parentHglrc, this.hglrc)) {
            throw new GLException("pbuffer: wglShareLists() failed");
        }
    }

    protected void destroyImpl() throws GLException {
        if (this.hglrc != 0L) {
            super.destroyImpl();
            GL gL = this.createGL();
            if (gL.wglReleasePbufferDCARB(this.buffer, this.hdc) == 0) {
                throw new GLException("Error releasing pbuffer device context: error code " + WGL.GetLastError());
            }
            this.hdc = 0L;
            if (!gL.wglDestroyPbufferARB(this.buffer)) {
                throw new GLException("Error destroying pbuffer: error code " + WGL.GetLastError());
            }
            this.buffer = 0L;
        }
    }

    public void swapBuffers() throws GLException {
        if (this.rtt && !this.hasRTT) {
            if (DEBUG) {
                System.err.println("Copying pbuffer data to GL_TEXTURE_2D state");
            }
            GL gL = this.getGL();
            gL.glCopyTexSubImage2D(this.textureTarget, 0, 0, 0, 0, 0, this.width, this.height);
        }
    }

    public int getFloatingPointMode() {
        return this.floatMode;
    }

    private String wglGetLastError() {
        int n = WGL.GetLastError();
        String string = null;
        switch (n) {
            case 2000: {
                string = "ERROR_INVALID_PIXEL_FORMAT";
                break;
            }
            case 1450: {
                string = "ERROR_NO_SYSTEM_RESOURCES";
                break;
            }
            case 13: {
                string = "ERROR_INVALID_DATA";
                break;
            }
            case 127: {
                string = "ERROR_PROC_NOT_FOUND";
                break;
            }
            case 1400: {
                string = "ERROR_INVALID_WINDOW_HANDLE";
                break;
            }
            default: {
                string = "(Unknown error code " + n + ")";
            }
        }
        return string;
    }

    static {
        $assertionsDisabled = !WindowsPbufferGLContext.class.desiredAssertionStatus();
        DEBUG = Debug.debug("WindowsPbufferGLContext");
    }
}

