/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import java.awt.GridLayout;
import java.io.InputStreamReader;
import javax.swing.BorderFactory;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.vecmath.Point3f;
import viewexplore.Camera;
import viewexplore.GLView;
import viewexplore.Mesh;
import viewexplore.OmniscientView;

public class ViewExplore
extends JFrame {
    public static void main(String[] argv) {
        new ViewExplore();
    }

    public ViewExplore() {
        super("View Explorer");
        this.setDefaultCloseOperation(3);
        JPanel panel = ViewExplore.makePanel();
        panel.setOpaque(true);
        this.setContentPane(panel);
        this.pack();
        this.setVisible(true);
    }

    public static JPanel makePanel() {
        JPanel panel = new JPanel(new GridLayout(2, 2, 2, 2));
        panel.setBorder(BorderFactory.createEmptyBorder(2, 2, 2, 2));
        Point3f origin = new Point3f(0.0f, 0.0f, 0.0f);
        GLView camView = new GLView("Screen Space", new Camera(new Point3f(5.0f, 5.0f, 3.0f), origin));
        OmniscientView worldView = new OmniscientView("World Space", 3, new Camera(new Point3f(10.0f, 10.0f, 6.0f), origin), camView.getCamera());
        OmniscientView eyeView = new OmniscientView("Camera/Eye Space", 2, new Camera(new Point3f(10.0f, 10.0f, 1.0f), new Point3f(0.0f, 0.0f, -5.0f)), camView.getCamera());
        OmniscientView clipView = new OmniscientView("Canonical View/Clip Space", 1, new Camera(new Point3f(5.0f, 5.0f, 3.0f), origin), camView.getCamera());
        camView.getCamera().setPerspective(2.0f, 10.0f, 20.0f);
        worldView.getCamera().setPerspective(0.1f, 100.0f, 35.0f);
        eyeView.getCamera().setPerspective(0.1f, 100.0f, 25.0f);
        clipView.getCamera().setPerspective(0.1f, 100.0f, 27.0f);
        camView.addDependent(worldView);
        camView.addDependent(eyeView);
        camView.addDependent(clipView);
        Mesh bunny = new Mesh();
        ClassLoader cl = Mesh.class.getClassLoader();
        Mesh.readMesh(bunny, new InputStreamReader(cl.getResourceAsStream("viewexplore/bunny500_norms.msh")));
        camView.setMesh(bunny);
        worldView.setMesh(bunny);
        eyeView.setMesh(bunny);
        clipView.setMesh(bunny);
        panel.add(worldView);
        panel.add(eyeView);
        panel.add(clipView);
        panel.add(camView);
        return panel;
    }
}

