/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.vecmath.Matrix4f;
import viewexplore.Camera;
import viewexplore.GLView;

public class OmniscientView
extends GLView {
    public static final int SPACE_CLIP = 1;
    public static final int SPACE_EYE = 2;
    public static final int SPACE_WORLD = 3;
    int space;
    Camera otherCamera;

    public OmniscientView(String name, int space, Camera camera, Camera otherCamera) {
        super(name, camera);
        this.space = space;
        this.otherCamera = otherCamera;
    }

    @Override
    protected void renderContent(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        float[] m = new float[16];
        Matrix4f projMat = new Matrix4f();
        Matrix4f camMat = new Matrix4f();
        gl.glMatrixMode(5889);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.otherCamera.doProjection(d);
        gl.glGetFloatv(34020, m, 0);
        projMat.set(m);
        gl.glPopMatrix();
        gl.glMatrixMode(5888);
        gl.glPushMatrix();
        gl.glLoadIdentity();
        this.otherCamera.doModelview(d);
        gl.glGetFloatv(34019, m, 0);
        camMat.set(m);
        gl.glPopMatrix();
        Matrix4f projMatInv = new Matrix4f();
        Matrix4f camMatInv = new Matrix4f();
        projMatInv.invert(projMat);
        camMatInv.invert(camMat);
        gl.glPushMatrix();
        if (this.space >= 3) {
            this.flattenMatrix(camMatInv, m);
            gl.glMultMatrixf(m, 0);
        }
        if (this.space >= 2) {
            this.flattenMatrix(projMatInv, m);
            gl.glMultMatrixf(m, 0);
        }
        gl.glPushAttrib(2896);
        gl.glDisable(2896);
        gl.glColor3f(0.9f, 0.8f, 0.6f);
        gl.glBegin(1);
        gl.glVertex3f(-1.0f, -1.0f, -1.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, -1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glVertex3f(1.0f, -1.0f, -1.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, -1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glVertex3f(-1.0f, -1.0f, -1.0f);
        gl.glVertex3f(-1.0f, 1.0f, -1.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glVertex3f(1.0f, -1.0f, -1.0f);
        gl.glVertex3f(1.0f, 1.0f, -1.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glVertex3f(-1.0f, -1.0f, -1.0f);
        gl.glVertex3f(1.0f, -1.0f, -1.0f);
        gl.glVertex3f(-1.0f, -1.0f, 1.0f);
        gl.glVertex3f(1.0f, -1.0f, 1.0f);
        gl.glVertex3f(-1.0f, 1.0f, -1.0f);
        gl.glVertex3f(1.0f, 1.0f, -1.0f);
        gl.glVertex3f(-1.0f, 1.0f, 1.0f);
        gl.glVertex3f(1.0f, 1.0f, 1.0f);
        gl.glEnd();
        gl.glPopAttrib();
        gl.glPopMatrix();
        gl.glPushMatrix();
        if (this.space <= 1) {
            this.flattenMatrix(projMat, m);
            gl.glMultMatrixf(m, 0);
        }
        if (this.space <= 2) {
            this.flattenMatrix(camMat, m);
            gl.glMultMatrixf(m, 0);
        }
        super.renderContent(d);
        gl.glPopMatrix();
    }

    void flattenMatrix(Matrix4f mat, float[] m) {
        int i = 0;
        int k = 0;
        while (i < 4) {
            int j = 0;
            while (j < 4) {
                m[k] = mat.getElement(j, i);
                ++j;
                ++k;
            }
            ++i;
        }
    }
}

