/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import com.jogamp.common.nio.Buffers;
import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.nio.Buffer;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import javax.media.opengl.GL2;
import javax.vecmath.Matrix4f;
import javax.vecmath.Point3f;
import javax.vecmath.Vector3f;

public class Mesh {
    protected int numVertices;
    protected int numTriangles;
    protected FloatBuffer verts;
    protected FloatBuffer texcoords;
    protected FloatBuffer normals;
    protected IntBuffer triangles = null;

    public Mesh() {
    }

    public Mesh(float[] verts, int[] tris, float[] normals, float[] texcoords) {
        if (verts.length % 3 != 0) {
            throw new Error("Vertex array for a triangle mesh is not a multiple of 3.");
        }
        if (tris.length % 3 != 0) {
            throw new Error("Triangle array for a triangle mesh is not a multiple of 3.");
        }
        this.setMeshData(verts, tris, normals, texcoords);
    }

    public FloatBuffer getNormals() {
        return this.normals;
    }

    public FloatBuffer getVerts() {
        return this.verts;
    }

    private void setMeshData(float[] verts, int[] tris, float[] normals, float[] texcoords) {
        this.verts = Buffers.newDirectFloatBuffer((int)verts.length);
        this.triangles = Buffers.newDirectIntBuffer((int)tris.length);
        if (normals != null) {
            this.normals = Buffers.newDirectFloatBuffer((int)normals.length);
        }
        if (texcoords != null) {
            this.texcoords = Buffers.newDirectFloatBuffer((int)texcoords.length);
        }
        this.numVertices = verts.length / 3;
        this.numTriangles = tris.length / 3;
        this.verts.put(verts);
        this.triangles.put(tris);
        if (normals != null) {
            this.normals.put(normals);
        }
        if (texcoords != null) {
            this.texcoords.put(texcoords);
        }
    }

    public int getNumTriangles() {
        return this.numTriangles;
    }

    public int getNumVertices() {
        return this.numVertices;
    }

    public void setData(String fileName) {
        try {
            Mesh.readMesh(this, new FileReader(fileName));
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
    }

    public void render(GL2 gl) {
        this.verts.rewind();
        if (this.normals != null) {
            this.normals.rewind();
        }
        if (this.texcoords != null) {
            this.texcoords.rewind();
        }
        this.triangles.rewind();
        gl.glVertexPointer(3, 5126, 0, (Buffer)this.verts);
        if (this.normals != null) {
            gl.glNormalPointer(5126, 0, (Buffer)this.normals);
        }
        if (this.texcoords != null) {
            gl.glTexCoordPointer(2, 5126, 0, (Buffer)this.texcoords);
        }
        gl.glEnableClientState(32884);
        if (this.normals != null) {
            gl.glEnableClientState(32885);
        }
        if (this.texcoords != null) {
            gl.glEnableClientState(32888);
        }
        gl.glDrawElements(4, 3 * this.numTriangles, 5125, (Buffer)this.triangles);
        gl.glDisableClientState(32884);
        gl.glDisableClientState(32885);
        gl.glDisableClientState(32888);
    }

    public void writeMesh(Matrix4f currMat, PrintWriter pw) {
        pw.println(this.numVertices);
        pw.println(this.numTriangles);
        Point3f currVert = new Point3f();
        pw.println("vertices");
        int i = 0;
        while (i < this.numVertices) {
            currVert.x = this.verts.get(3 * i);
            currVert.y = this.verts.get(3 * i + 1);
            currVert.z = this.verts.get(3 * i + 2);
            currMat.transform(currVert);
            pw.println(currVert.x);
            pw.println(currVert.y);
            pw.println(currVert.z);
            ++i;
        }
        pw.println("triangles");
        i = 0;
        while (i < this.triangles.array().length) {
            pw.println(this.triangles.array()[i]);
            ++i;
        }
        if (this.texcoords != null) {
            pw.println("texcoords");
            i = 0;
            while (i < this.texcoords.capacity()) {
                pw.println(this.texcoords.get(i));
                ++i;
            }
        }
        if (this.normals != null) {
            Vector3f currNorm = new Vector3f();
            Matrix4f invTrans = new Matrix4f(currMat);
            invTrans.transpose();
            invTrans.invert();
            pw.println("normals");
            int i2 = 0;
            while (i2 < this.numVertices) {
                currNorm.x = this.normals.get(3 * i2);
                currNorm.y = this.normals.get(3 * i2 + 1);
                currNorm.z = this.normals.get(3 * i2 + 2);
                invTrans.transform(currNorm);
                currNorm.normalize();
                pw.println(currNorm.x);
                pw.println(currNorm.y);
                pw.println(currNorm.z);
                ++i2;
            }
        }
    }

    public static final void readMesh(Mesh outputMesh, Reader reader) {
        float[] texcoords;
        float[] normals;
        int[] triangles;
        float[] vertices;
        try {
            int i;
            BufferedReader fr = new BufferedReader(reader);
            int nPoints = Integer.parseInt(fr.readLine());
            int nPolys = Integer.parseInt(fr.readLine());
            vertices = new float[nPoints * 3];
            triangles = new int[nPolys * 3];
            normals = null;
            texcoords = null;
            if (!fr.readLine().equals("vertices")) {
                throw new RuntimeException("Broken file - vertices expected");
            }
            int i2 = 0;
            while (i2 < vertices.length) {
                vertices[i2] = Float.parseFloat(fr.readLine());
                ++i2;
            }
            if (!fr.readLine().equals("triangles")) {
                throw new RuntimeException("Broken file - triangles expected.");
            }
            i2 = 0;
            while (i2 < triangles.length) {
                triangles[i2] = Integer.parseInt(fr.readLine());
                ++i2;
            }
            String line = fr.readLine();
            if (line != null && line.equals("texcoords")) {
                texcoords = new float[nPoints * 2];
                line = null;
                i = 0;
                while (i < texcoords.length) {
                    texcoords[i] = Float.parseFloat(fr.readLine());
                    ++i;
                }
            }
            if (line == null) {
                line = fr.readLine();
            }
            if (line != null && line.equals("normals")) {
                normals = new float[nPoints * 3];
                i = 0;
                while (i < normals.length) {
                    normals[i] = Float.parseFloat(fr.readLine());
                    ++i;
                }
            }
        }
        catch (Exception e) {
            throw new Error("Error reading mesh");
        }
        outputMesh.setMeshData(vertices, triangles, normals, texcoords);
        System.out.println("Read mesh of " + vertices.length + " verts");
    }
}

