/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.LinkedList;
import java.util.List;
import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.GLCapabilities;
import javax.media.opengl.GLCapabilitiesImmutable;
import javax.media.opengl.GLEventListener;
import javax.media.opengl.GLProfile;
import javax.media.opengl.awt.GLCanvas;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.vecmath.Tuple2f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;
import viewexplore.Camera;
import viewexplore.GLAxes;
import viewexplore.Mesh;

public class GLView
extends JPanel
implements GLEventListener {
    private static final String ORTHOGRAPHIC_CHECKBOX_TEXT = "Orthographic";
    private static final String WIREFRAME_CHECKBOX_TEXT = "Wireframe";
    private static final String LIGHTING_CHECKBOX_TEXT = "Lighting";
    protected boolean orthographic = false;
    protected boolean wireframe = false;
    protected boolean lighting = true;
    protected GLCanvas canvas;
    protected Camera camera;
    protected GLAxes axes;
    protected EventHandler handler;
    protected List<GLView> dependents = new LinkedList<GLView>();
    protected Mesh mesh = null;
    String name;
    public static final float AMBIENT_CONSTANT = 0.05f;
    public static final float DIFFUSE_CONSTANT = 0.4f;
    public final float[] ambient = new float[]{0.05f, 0.05f, 0.05f, 1.0f};
    public final float[] diffuse = new float[]{0.4f, 0.4f, 0.4f, 1.0f};
    public final float[] specular = new float[]{2.0f, 2.0f, 2.0f, 1.0f};
    public final float[] position = new float[]{6.0f, 8.0f, 10.0f, 1.0f};
    public final float[] diffuseColor = new float[]{0.2f, 0.4f, 1.0f, 1.0f};
    public final float[] specularColor = new float[]{0.0f, 0.0f, 0.0f, 1.0f};
    public final float expSpecular = 100.0f;

    public GLView(String name, Camera newCamera) {
        this.name = name;
        this.handler = new EventHandler();
        this.camera = newCamera;
        this.axes = new GLAxes();
        GLProfile profile = GLProfile.getDefault();
        GLCapabilities capabilities = new GLCapabilities(profile);
        capabilities.setDoubleBuffered(true);
        this.canvas = new GLCanvas((GLCapabilitiesImmutable)capabilities);
        this.canvas.setSize(600, 400);
        this.canvas.addGLEventListener((GLEventListener)this);
        this.setLayout(new BorderLayout());
        this.add((Component)this.canvas, "Center");
        this.add((Component)this.createTopPanel(), "North");
        this.canvas.addMouseListener((MouseListener)this.handler);
        this.canvas.addMouseMotionListener((MouseMotionListener)this.handler);
        this.setMinimumSize(new Dimension(250, 250));
    }

    protected JComponent createTopPanel() {
        JPanel toReturn = new JPanel(new BorderLayout());
        toReturn.add((Component)new JLabel(this.name), "West");
        JPanel temp = new JPanel(new GridLayout(1, 2));
        JCheckBox orthoBox = new JCheckBox(ORTHOGRAPHIC_CHECKBOX_TEXT, this.camera.isOrthographic());
        orthoBox.addActionListener(this.handler);
        temp.add(orthoBox);
        JCheckBox wireBox = new JCheckBox(WIREFRAME_CHECKBOX_TEXT, this.wireframe);
        wireBox.addActionListener(this.handler);
        temp.add(wireBox);
        JCheckBox lightBox = new JCheckBox(LIGHTING_CHECKBOX_TEXT, this.lighting);
        lightBox.addActionListener(this.handler);
        temp.add(lightBox);
        toReturn.add((Component)temp, "East");
        toReturn.add((Component)new JPanel(), "Center");
        return toReturn;
    }

    public void displayChanged(GLAutoDrawable d, boolean arg1, boolean arg2) {
        this.refresh();
    }

    public void refresh() {
        this.canvas.repaint();
        for (GLView dependent : this.dependents) {
            dependent.refresh();
        }
    }

    protected void lightSetup(GL2 gl) {
        gl.glLightModeli(33272, 33274);
        gl.glLightModelfv(2899, new float[]{0.1f, 0.1f, 0.1f}, 0);
        gl.glLightModeli(2897, 1);
        gl.glLightModeli(2898, 1);
        gl.glLightfv(0, 4611, this.position, 0);
        gl.glLightfv(0, 4609, this.diffuse, 0);
        gl.glLightfv(0, 4608, this.ambient, 0);
        gl.glLightfv(0, 4610, this.specular, 0);
        gl.glEnable(16384);
    }

    public void init(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        gl.glDepthFunc(513);
        gl.glEnable(2929);
        gl.glBlendFunc(770, 771);
        gl.glEnable(3042);
        gl.glEnable(2977);
        gl.glEnable(32925);
        gl.glShadeModel(7424);
        gl.glClearColor(0.2f, 0.2f, 0.2f, 1.0f);
        this.lightSetup(gl);
    }

    protected void displaySetup() {
        GL2 gl = this.canvas.getGL().getGL2();
        if (this.wireframe) {
            gl.glCullFace(1029);
            gl.glDisable(2884);
            gl.glPolygonMode(1032, 6913);
        } else {
            gl.glCullFace(1029);
            gl.glPolygonMode(1032, 6914);
        }
        if (this.lighting) {
            gl.glEnable(2896);
        } else {
            gl.glDisable(2896);
        }
    }

    public void display(GLAutoDrawable d) {
        GL2 gl = this.canvas.getGL().getGL2();
        this.displaySetup();
        gl.glClear(16640);
        gl.glViewport(0, 0, this.canvas.getWidth(), this.canvas.getHeight());
        gl.glMatrixMode(5889);
        gl.glLoadIdentity();
        this.camera.doProjection((GLAutoDrawable)this.canvas);
        gl.glMatrixMode(5888);
        gl.glLoadIdentity();
        this.camera.doModelview((GLAutoDrawable)this.canvas);
        this.renderContent(d);
        this.axes.glRenderAxes(d);
        this.axes.glRenderGrid(d);
    }

    protected void renderContent(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        if (this.mesh != null) {
            gl.glMaterialfv(1028, 4609, this.diffuseColor, 0);
            gl.glMaterialfv(1028, 4608, this.diffuseColor, 0);
            gl.glMaterialfv(1028, 4610, this.specularColor, 0);
            gl.glMaterialf(1028, 5633, 100.0f);
            gl.glColor3fv(this.diffuseColor, 0);
            this.mesh.render(d.getGL().getGL2());
        }
    }

    public void reshape(GLAutoDrawable d, int x, int y, int width, int height) {
        this.camera.setAspect((float)width / (float)height);
    }

    public void addDependent(GLView dependent) {
        this.dependents.add(dependent);
    }

    public Camera getCamera() {
        return this.camera;
    }

    public void setCamera(Camera camera) {
        this.camera = camera;
    }

    public void setMesh(Mesh mesh) {
        this.mesh = mesh;
    }

    public void dispose(GLAutoDrawable arg0) {
    }

    private class EventHandler
    extends MouseAdapter
    implements MouseMotionListener,
    ActionListener {
        Vector3f motion = new Vector3f();
        protected int lastMousePixel_X;
        protected int lastMousePixel_Y;
        protected Vector2f lastMousePoint = new Vector2f();
        protected Vector2f currentMousePoint = new Vector2f();
        protected Vector2f mouseDelta = new Vector2f();
        protected final int MOUSE_PICK = 0;
        protected final int MOUSE_MANIP = 1;
        protected final int MOUSE_ORBIT = 61;
        protected final int MOUSE_ZOOM = 62;
        protected final int MOUSE_TRACK = 63;
        protected final int MOUSE_DOLLY = 64;
        protected final int MOUSE_NEAR = 65;
        protected final int MOUSE_FAR = 66;
        public int mouseMode = 0;

        private EventHandler() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            this.lastMousePixel_X = e.getX();
            this.lastMousePixel_Y = e.getY();
            this.lastMousePoint.set((float)this.lastMousePixel_X, (float)this.lastMousePixel_Y);
            this.windowToViewport((Tuple2f)this.lastMousePoint);
            this.updateState(e);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            this.mouseMode = 0;
        }

        protected void updateState(MouseEvent e) {
            this.mouseMode = this.flagSet(e, 1024) && !this.flagSet(e, 4096) && !this.flagSet(e, 128) && !this.flagSet(e, 512) ? 61 : (this.flagSet(e, 1024) && !this.flagSet(e, 4096) && this.flagSet(e, 128) && !this.flagSet(e, 512) ? 63 : (!this.flagSet(e, 1024) && this.flagSet(e, 4096) && !this.flagSet(e, 128) && !this.flagSet(e, 512) ? 64 : (!this.flagSet(e, 1024) && this.flagSet(e, 4096) && this.flagSet(e, 128) && !this.flagSet(e, 512) ? 62 : (!this.flagSet(e, 1024) && this.flagSet(e, 4096) && !this.flagSet(e, 128) && this.flagSet(e, 512) && this.flagSet(e, 64) ? 65 : (!this.flagSet(e, 1024) && this.flagSet(e, 4096) && !this.flagSet(e, 128) && this.flagSet(e, 512) && !this.flagSet(e, 64) ? 66 : 0)))));
        }

        protected void windowToViewport(Tuple2f p) {
            int w = GLView.this.canvas.getWidth();
            int h = GLView.this.canvas.getHeight();
            p.set((2.0f * p.x - (float)w) / (float)w, (2.0f * ((float)h - p.y - 1.0f) - (float)h) / (float)h);
        }

        protected boolean flagSet(MouseEvent e, int flag) {
            return (e.getModifiersEx() & flag) == flag;
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            this.currentMousePoint.set((float)e.getX(), (float)e.getY());
            this.windowToViewport((Tuple2f)this.currentMousePoint);
            this.mouseDelta.set((Tuple2f)this.currentMousePoint);
            this.mouseDelta.sub((Tuple2f)this.lastMousePoint);
            switch (this.mouseMode) {
                case 63: {
                    GLView.this.camera.track(this.mouseDelta);
                    break;
                }
                case 61: {
                    GLView.this.camera.orbit(this.mouseDelta);
                    break;
                }
                case 62: {
                    GLView.this.camera.zoom(this.mouseDelta.y);
                    break;
                }
                case 64: {
                    GLView.this.camera.dolly(this.mouseDelta.y);
                    break;
                }
                case 65: {
                    GLView.this.camera.setNear((float)((double)GLView.this.camera.getNear() * Math.exp(2.0f * this.mouseDelta.y)));
                    break;
                }
                case 66: {
                    GLView.this.camera.setFar((float)((double)GLView.this.camera.getFar() * Math.exp(2.0f * this.mouseDelta.y)));
                }
            }
            this.lastMousePoint.set((float)e.getX(), (float)e.getY());
            this.windowToViewport((Tuple2f)this.lastMousePoint);
            GLView.this.refresh();
        }

        @Override
        public void mouseMoved(MouseEvent e) {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            String cmd = e.getActionCommand();
            if (cmd == null) {
                return;
            }
            if (cmd.equals(GLView.WIREFRAME_CHECKBOX_TEXT)) {
                GLView.this.wireframe = !GLView.this.wireframe;
            } else if (cmd.equals(GLView.LIGHTING_CHECKBOX_TEXT)) {
                GLView.this.lighting = !GLView.this.lighting;
            } else if (cmd.equals(GLView.ORTHOGRAPHIC_CHECKBOX_TEXT)) {
                GLView.this.camera.setOrthographic(((JCheckBox)e.getSource()).isSelected());
            }
            GLView.this.refresh();
        }
    }
}

