/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;

public class GLAxes {
    public static final byte X_AXIS = 0;
    public static final byte Y_AXIS = 1;
    public static final byte Z_AXIS = 2;
    private static double arrowDivs = 32.0;
    private static double arrowHeadRadius = 0.11;
    private static double arrowTailRadius = 0.05;
    private int cache = -1;

    public void glRenderAxes(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        gl.glPushAttrib(2896);
        gl.glDisable(2896);
        if (this.cache == -1) {
            this.cache = gl.glGenLists(1);
            gl.glNewList(this.cache, 4865);
            gl.glPushAttrib(6144);
            gl.glColor4f(1.0f, 0.2f, 0.2f, 0.4f);
            GLAxes.glRenderArrow((byte)0, gl);
            gl.glColor4f(0.2f, 1.0f, 0.2f, 0.4f);
            GLAxes.glRenderArrow((byte)1, gl);
            gl.glColor4f(0.2f, 0.2f, 1.0f, 0.4f);
            GLAxes.glRenderArrow((byte)2, gl);
            gl.glPopAttrib();
            gl.glEndList();
        } else {
            gl.glCallList(this.cache);
        }
        gl.glPopAttrib();
    }

    public void glRenderGrid(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        int bigness = 10;
        gl.glPushAttrib(2896);
        gl.glDisable(2896);
        gl.glColor3f(0.4f, 0.4f, 0.4f);
        gl.glBegin(1);
        int i = -bigness;
        while (i <= bigness) {
            gl.glVertex3f((float)i, 0.0f, (float)(-bigness));
            gl.glVertex3f((float)i, 0.0f, (float)bigness);
            gl.glVertex3f((float)(-bigness), 0.0f, (float)i);
            gl.glVertex3f((float)bigness, 0.0f, (float)i);
            ++i;
        }
        gl.glEnd();
        gl.glColor4f(0.12f, 0.12f, 0.12f, 0.4f);
        gl.glBegin(7);
        gl.glVertex3f((float)(-bigness), -0.01f, (float)(-bigness));
        gl.glVertex3f((float)(-bigness), -0.01f, (float)bigness);
        gl.glVertex3f((float)bigness, -0.01f, (float)bigness);
        gl.glVertex3f((float)bigness, -0.01f, (float)(-bigness));
        gl.glEnd();
        gl.glPopAttrib();
    }

    public static void glRenderArrow(byte axis, GL2 gl) {
        gl.glPushMatrix();
        switch (axis) {
            case 0: {
                gl.glRotatef(90.0f, 0.0f, 0.0f, -1.0f);
                break;
            }
            case 2: {
                gl.glRotatef(90.0f, 1.0f, 0.0f, 0.0f);
            }
        }
        double theta = 0.0;
        gl.glBegin(6);
        gl.glVertex3d(0.0, 0.0, 0.0);
        double i = 0.0;
        while (i <= arrowDivs) {
            theta = i / arrowDivs * Math.PI * 2.0;
            gl.glVertex3d(Math.cos(theta) * arrowTailRadius, 1.8, Math.sin(theta) * arrowTailRadius);
            i += 1.0;
        }
        gl.glEnd();
        gl.glBegin(8);
        i = 0.0;
        while (i <= arrowDivs) {
            theta = i / arrowDivs * Math.PI * 2.0;
            gl.glVertex3d(Math.cos(theta) * arrowTailRadius, 1.8, Math.sin(theta) * arrowTailRadius);
            gl.glVertex3d(Math.cos(theta) * arrowHeadRadius, 1.83, Math.sin(theta) * arrowHeadRadius);
            i += 1.0;
        }
        gl.glEnd();
        gl.glBegin(6);
        gl.glVertex3d(0.0, 2.0, 0.0);
        i = 0.0;
        while (i <= arrowDivs) {
            theta = i / arrowDivs * Math.PI * 2.0;
            gl.glVertex3d(Math.cos(theta) * arrowHeadRadius, 1.83, Math.sin(theta) * arrowHeadRadius);
            i += 1.0;
        }
        gl.glEnd();
        gl.glPopMatrix();
    }

    public static void glRenderArrow(GL2 gl) {
        GLAxes.glRenderArrow((byte)1, gl);
    }
}

