/*
 * Decompiled with CFR 0.152.
 */
package viewexplore;

import javax.media.opengl.GL2;
import javax.media.opengl.GLAutoDrawable;
import javax.media.opengl.glu.GLU;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector2f;
import javax.vecmath.Vector3f;

public class Camera {
    protected final Point3f eye = new Point3f();
    protected final Point3f target = new Point3f();
    protected float aspect = 1.0f;
    protected float height = 0.2f;
    protected float shiftHoriz = 0.0f;
    protected float shiftVert = 0.0f;
    protected float near = 1.0f;
    protected float far = 10.0f;
    protected boolean orthographic = false;
    protected final Vector3f up = new Vector3f();
    protected final Vector3f right = new Vector3f();
    private GLU glu;
    private static final Vector3f VERTICAL = new Vector3f(0.0f, 1.0f, 0.0f);
    protected String name;

    public Camera(Point3f eye, Point3f target) {
        this.eye.set((Tuple3f)eye);
        this.target.set((Tuple3f)target);
        this.updateFrame();
        this.glu = new GLU();
    }

    public void setPerspective(float near, float far, float fovy) {
        this.near = near;
        this.far = far;
        this.height = 2.0f * (float)Math.tan((double)fovy * (Math.PI / 180) / 2.0);
        this.shiftVert = 0.0f;
        this.shiftHoriz = 0.0f;
    }

    public void updateFrame() {
        Vector3f negGaze = new Vector3f((Tuple3f)this.eye);
        negGaze.sub((Tuple3f)this.target);
        negGaze.normalize();
        this.right.cross(VERTICAL, negGaze);
        this.right.normalize();
        this.up.cross(negGaze, this.right);
    }

    public Point3f getEye() {
        return this.eye;
    }

    public Point3f getTarget() {
        return this.target;
    }

    public float getAspect() {
        return this.aspect;
    }

    public void setAspect(float d) {
        this.aspect = d;
    }

    public float getNear() {
        return this.near;
    }

    public void setNear(float near) {
        this.near = near;
    }

    public float getFar() {
        return this.far;
    }

    public void setFar(float far) {
        this.far = far;
    }

    public boolean isOrthographic() {
        return this.orthographic;
    }

    public void setOrthographic(boolean orthographic) {
        this.orthographic = orthographic;
    }

    public void translate(Vector3f delta) {
        this.eye.add((Tuple3f)delta);
        this.target.add((Tuple3f)delta);
    }

    public void flip() {
        Vector3f offset = new Vector3f();
        offset.sub((Tuple3f)this.eye, (Tuple3f)this.target);
        offset.negate();
        this.eye.add((Tuple3f)this.target, (Tuple3f)offset);
    }

    public void track(Vector2f mouseDelta) {
        Vector3f temp = new Vector3f();
        this.convertMotion(mouseDelta, temp);
        this.eye.add((Tuple3f)temp);
        this.target.add((Tuple3f)temp);
    }

    public float getEffectiveHeight() {
        float dist = this.eye.distance(this.target);
        return this.height * dist;
    }

    public void convertMotion(Vector2f delta, Vector3f output) {
        output.scale(-delta.x * this.aspect * this.getEffectiveHeight(), (Tuple3f)this.right);
        output.scaleAdd(-delta.y * this.getEffectiveHeight(), (Tuple3f)this.up, (Tuple3f)output);
    }

    public void doProjection(GLAutoDrawable d) {
        GL2 gl = d.getGL().getGL2();
        if (this.orthographic) {
            float left = this.shiftHoriz - this.aspect * this.getEffectiveHeight() / 2.0f;
            float right = this.shiftHoriz + this.aspect * this.getEffectiveHeight() / 2.0f;
            float bottom = this.shiftVert - this.getEffectiveHeight() / 2.0f;
            float top = this.shiftVert + this.getEffectiveHeight() / 2.0f;
            gl.glOrtho((double)left, (double)right, (double)bottom, (double)top, (double)this.near, (double)this.far);
        } else {
            float left = this.shiftHoriz - this.aspect * this.height / 2.0f;
            float right = this.shiftHoriz + this.aspect * this.height / 2.0f;
            float bottom = this.shiftVert - this.height / 2.0f;
            float top = this.shiftVert + this.height / 2.0f;
            gl.glFrustum((double)(this.near * left), (double)(this.near * right), (double)(this.near * bottom), (double)(this.near * top), (double)this.near, (double)this.far);
        }
    }

    public void doModelview(GLAutoDrawable d) {
        this.glu.gluLookAt(this.eye.x, this.eye.y, this.eye.z, this.target.x, this.target.y, this.target.z, this.up.x, this.up.y, this.up.z);
    }

    public boolean getAllowsChildren() {
        return false;
    }

    public void orbit(Vector2f mouseDelta) {
        Vector3f negGaze = new Vector3f((Tuple3f)this.eye);
        negGaze.sub((Tuple3f)this.target);
        float dist = negGaze.length();
        negGaze.normalize();
        float azimuth = (float)Math.atan2(negGaze.x, negGaze.z);
        float elevation = (float)Math.atan2(negGaze.y, Math.sqrt(negGaze.x * negGaze.x + negGaze.z * negGaze.z));
        azimuth = (azimuth - mouseDelta.x) % ((float)Math.PI * 2);
        elevation = (float)Math.max(-1.5550883635269477, Math.min(1.5550883635269477, (double)(elevation - mouseDelta.y)));
        negGaze.set((float)(Math.sin(azimuth) * Math.cos(elevation)), (float)Math.sin(elevation), (float)(Math.cos(azimuth) * Math.cos(elevation)));
        negGaze.normalize();
        this.eye.scaleAdd(dist, (Tuple3f)negGaze, (Tuple3f)this.target);
        this.updateFrame();
    }

    public void dolly(float d) {
        Vector3f gaze = new Vector3f((Tuple3f)this.target);
        gaze.sub((Tuple3f)this.eye);
        gaze.scale((float)Math.exp(4.0f * d));
        this.eye.sub((Tuple3f)this.target, (Tuple3f)gaze);
    }

    public void zoom(float d) {
        this.height = (float)((double)this.height * Math.exp(4.0f * d));
    }
}

