/*
 * Author andru
 */

package modeler;

import javax.media.opengl.GL;
import javax.media.opengl.GLAutoDrawable;

/**
 * Class that models the coordinate axes
 * @author arbree
 * Oct 21, 2005
 * GLAxes.java
 * Copyright 2005 Program of Computer Graphics, Cornell University
 */
public class GLAxes {

  // This is a nice example of how to use display lists to speed up drawing
  // objects once you've computed static geometry for an object.
  private int cache = -1;
  private double constantSize = 0.3;
  
  /**
   * Render the axes
   * @param d
   */
  public void glRender(GLAutoDrawable d) {

    GL gl = d.getGL();

    gl.glPushAttrib(GL.GL_LIGHTING);
    gl.glDisable(GL.GL_LIGHTING);
    if (cache == -1) {
      cache = gl.glGenLists(1);
      gl.glNewList(cache, GL.GL_COMPILE_AND_EXECUTE);
      gl.glPushAttrib(GL.GL_COLOR);
      gl.glColor4f(1f, .2f, .2f, 0.4f);
      Manip.glRenderArrow(Manip.X_AXIS, gl);

      gl.glColor4f(.2f, 1f, .2f, 0.4f);
      Manip.glRenderArrow(Manip.Y_AXIS, gl);

      gl.glColor4f(.2f, .2f, 1f, 0.4f);
      Manip.glRenderArrow(Manip.Z_AXIS, gl);

      gl.glPopAttrib();
      gl.glEndList();
    }
    else {
      gl.glCallList(cache);
    }
    gl.glPopAttrib();
  }

  /**
   * Render the axes at a constant size in the given camera
   * @param d
   * @param camera
   */
  public void renderConstantSize(GLAutoDrawable d, Camera camera) {

    GL gl = d.getGL();
    double scale = camera.getHeight() * constantSize;
    gl.glPushMatrix();
    gl.glScaled(scale, scale, scale);
    glRender(d);
    gl.glPopMatrix();
  }

}
