/** Reader/writer lock version 1
 * Noted if read_vector() function is continuously been called, then it may cause write_vector() to be blocked and starved
*/

#include <iostream>
#include <thread>
#include <mutex>
#include <shared_mutex>
#include <vector>

std::vector<int> global_vect{ 10, 20, 30 };
std::shared_mutex global_mutex;


/** Reader function
  * @param v: external vector to read to
  */
void read_vector(std::vector<int>& v){
     std::shared_lock<std::shared_mutex> read_lck(global_mutex);
     // Simulate some latency
     std::this_thread::sleep_for(std::chrono::seconds(1));     
     for(int i = 0; i < global_vect.size(); ++i){
          v[i] = global_vect[i];
          
     }
}

/** Writer function
  * @param new_val: new value to write to the entire global_vect
  */
void write_vector(int new_val){
     std::scoped_lock<std::shared_mutex> write_lck(global_mutex);
     for(size_t i = 0; i < global_vect.size(); ++i){
          global_vect[i] = new_val;
          std::this_thread::sleep_for(std::chrono::seconds(1)); 
     }
}

void print_vector(const std::vector<int>& vect){
     std::cout << "[";
     for(const int& val: vect){
          std::cout << val << ",";
     }
     std::cout << "]" << std::endl;
}

int main(){
     std::vector<int> read_vect0(3);
     std::vector<int> read_vect1(3);
     std::vector<int> read_vect2(3);

     std::thread t0(read_vector, std::ref(read_vect0));
     std::thread t3(write_vector, 0);
     std::thread t1(read_vector, std::ref(read_vect1));
     std::thread t2(read_vector, std::ref(read_vect2));
     
     t0.join();
     t1.join();
     t2.join();
     t3.join();

     std::cout << "read_vect0:";
     print_vector(read_vect0);
     std::cout << "read_vect1:";
     print_vector(read_vect1);
     std::cout << "read_vect2:";
     print_vector(read_vect2);
     std::cout << "global_vect:";
     print_vector(global_vect);


}
