#include <algorithm>
#include <iostream>

#include "bignum.hpp"
#include "exceptions.hpp"

void usage() {
    // not sure whether to print bignum or name of the binary
    std::cout << "Usage: bignum op number1 number2" << std::endl;
}

int main(int argc, char* argv[]) {
    if(argc != 4) {
        usage();
        return 1;
    }

    char op = argv[1][0];
    if(argv[1][1] != 0
       || std::find(bignum::Bignum::operators.begin(),
                    bignum::Bignum::operators.end(), op)
                  == bignum::Bignum::operators.end()) {
        std::cout << "Error: " << argv[1]
                  << " is not a supported operator" << std::endl;
        return 1;
    }

    try {
        bignum::Bignum num1(argv[2]);
        bignum::Bignum num2(argv[3]);

        bignum::Bignum result;
        switch(op) {
            case '+':
                result = num1 + num2;
                break;
            case '-':
                result = num1 - num2;
                break;
            case '*':
                result = num1 * num2;
		break;
            default:
                std::cout << "Not handled" << std::endl;
        }

        std::cout << result.to_string() << std::endl;
    } catch(const bignum::parse_error& e) {
        std::cout << "Error: \"" << e.strnum
                  << "\" is not an unsigned integer" << std::endl;
        return 1;
    } catch(const bignum::negative_number_error& e) {
        std::cout << "Unsupported: Negative number" << std::endl;
        return 1;
    }
}
