#pragma once

#include <string>
#include <vector>

namespace bignum {
class Bignum {
public:
    Bignum(const std::string& strnum);
    Bignum() = default;

    Bignum(const Bignum&) = delete;
    Bignum(Bignum&&) = default;
    Bignum& operator=(const Bignum&) = delete;
    Bignum& operator=(Bignum&&) = default;

    static const std::vector<char> operators;
    Bignum operator+(const Bignum& other) const;
    Bignum operator-(const Bignum& other) const;
    Bignum operator*(const Bignum& other) const;
    
    bool operator<(const Bignum& other) const;
    bool operator==(const Bignum& other) const;

    uint8_t& operator[](uint32_t idx);
    uint8_t operator[](uint32_t idx) const;

    uint32_t num_digits() const;
    std::string to_string() const;

private:
    Bignum(const uint32_t num_digits);

    std::vector<uint8_t> digits;

    std::vector<uint8_t> parse(const std::string& strnum) const;
    void purge();
};
}  // namespace bignum
