/*
 * $Id: Porch.java 406 2009-02-19 19:44:41Z msiegen $
 *
 * CS 4410 Dog Walking Simulator
 *
 */

package edu.cornell.cs4410.hw2;

public class Porch {
	
	public enum LightColor {
		BLACK, RED, GREEN
	}
	
	private Dog dog;
	private Park park;
	private boolean cameFromHouse = true;
	private LightColor light = LightColor.BLACK;
	
	public Porch(Dog dog, Park park) {
		this.dog = dog;
		this.park = park;
	}

	public void RFID_Detect() throws InterruptedException {
		if (cameFromHouse) {
			// The dog wants to walk
			LIGHT_Set(LightColor.RED);
			park.EnterPark(this.dog); // wait if necessary
			LIGHT_Set(LightColor.GREEN);
			// The dog is now allowed to enter the park
		} else {
			// The dog has finished walking
			park.LeavePark(this.dog);
		}
	}
	
	public void RFID_Offline() {
		if (cameFromHouse)
			LIGHT_Set(LightColor.BLACK);
		// Assume the dog never changes its mind while on the porch...
		cameFromHouse = !cameFromHouse;
	}
	
	public void LIGHT_Set(LightColor color) {
		light = color;
		System.out.println("Light for " + dog.dogName + " set to " + light.toString());
	}
	
}
