/*
 * $Id: Park.java 406 2009-02-19 19:44:41Z msiegen $
 *
 * CS 4410 Dog Walking Simulator
 *
 */

package edu.cornell.cs4410.hw2;

import java.util.concurrent.locks.*;

public class Park {
	
	private int goodDogsInPark = 0;
	private int badDogsInPark = 0;
	private int goodDogsWaiting = 0;
	private int badDogsWaiting = 0;
	
	// Create a lock for mutual exclusion
	private final Lock lock = new ReentrantLock();
	
	// Create condition variables that are associated with the above lock
	private final Condition goodDogsWaitingCond = lock.newCondition();
	private final Condition badDogsWaitingCond = lock.newCondition();

	public void EnterPark(Dog dog) throws InterruptedException {
		
		lock.lock(); // protect the logic in this critical region
		try {
		
			if (dog instanceof GoodDog) {
				
				if (badDogsInPark == 0 && badDogsWaiting == 0) {
					goodDogsInPark++;
					return; // Successfully entered park
				} else {
					// Need to wait for some bad dogs to finish their turn
					goodDogsWaiting++;
					try {
						// Wait until this dog is allowed to walk. While
						// waiting, the lock is released so that other
						// threads can enter the critical region.
						goodDogsWaitingCond.await();
						goodDogsInPark++;
						return; // Successfully entered park
					} finally {
						goodDogsWaiting--;
					}
				}
				
			} else if (dog instanceof BadDog) {
				
				if (goodDogsInPark == 0 && goodDogsWaiting == 0 && badDogsInPark == 0) {
					badDogsInPark++;
					return; // Successfully entered park
				} else {
					// Need to wait for some good dogs to finish their turn
					badDogsWaiting++;
					try {
						badDogsWaitingCond.await();
						badDogsInPark++;
						return; // Successfully entered park
					} finally {
						badDogsWaiting--;
					}
				}
				
			} else {
				System.out.println("Error: dog is neither good nor bad!");
			}
			
		} finally {
			// This lock gets released even if an exception occurred
			lock.unlock();
		}
	}
	
	public void LeavePark(Dog dog) {
		
		lock.lock();
		try {
			
			if (dog instanceof GoodDog) {
				
				goodDogsInPark--;
				if (goodDogsInPark == 0 && badDogsWaiting > 0) {
					// Allow ONE bad dog to enter the park
					badDogsWaitingCond.signal();
				}
				
			} else if (dog instanceof BadDog) {
				
				badDogsInPark--;
				if (goodDogsWaiting > 0) {
					// Allow ALL waiting good dogs to enter the park
					goodDogsWaitingCond.signalAll();
				}
				
			} else {
				System.out.println("Error: dog is neither good nor bad!");
			}
		
		} finally {
			// This lock gets released even if an exception occurred
			lock.unlock();
		}
	}

}
