/*
 * $Id: Dog.java 406 2009-02-19 19:44:41Z msiegen $
 *
 * CS 4410 Dog Walking Simulator
 *
 */

package edu.cornell.cs4410.hw2;

import java.util.Random;

public class Dog extends Thread {

	protected String dogName;
	protected Random generator = new Random();
	protected Porch porch;
	
	public Dog(String dogName) {
		this.dogName = dogName;
	}
	
	// This method will be automatically called in a new thread
	// when the programmer invokes the start() method.
	public void run() {
		try {
			while (true) { // Loop forever...
				takeNap();
				goForWalk();
			}
		} catch (InterruptedException e) {
			e.printStackTrace();
		}
	}
	
	private void takeNap() throws InterruptedException {
		int napTime = (int)(generator.nextDouble()*5000);
		System.out.println(dogName + " is napping for " + napTime + " ms");
		Thread.sleep(napTime);
	}
	
	private void goForWalk() throws InterruptedException {
		System.out.println(dogName + " wants to go for a walk");
		porch.RFID_Detect(); // Wait for green light
		int walkTime = (int)(generator.nextDouble()*2000);
		System.out.println(dogName + " is taking a walk for " + walkTime + " ms");
		porch.RFID_Offline();
		try {
			Thread.sleep(walkTime); // walk for a while
		} finally {
			// Make sure we leave the park, even in the even of an error
			System.out.println(dogName + " has gone home");
			porch.RFID_Detect(); // go back onto the porch
			porch.RFID_Offline(); // go back into the house
		}
	}

	public void setPorch(Porch porch) {
		this.porch = porch;
	}
}
