<!-- edited with XML Spy v4.2 U (http://www.xmlspy.com) by Carl Lagoze (Cornell University) -->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
	<xsl:output method="html"/>
	<xsl:template name="admonition">
		<xsl:param name="type">Warning</xsl:param>
		<table border="1">
			<tr>
				<th>
					<xsl:value-of select="$type"/>:</th>
			</tr>
			<tr>
				<td>
					<xsl:apply-templates/>
				</td>
			</tr>
		</table>
	</xsl:template>
	<xsl:template match="warning">
		<xsl:call-template name="admonition"/>
	</xsl:template>
	<xsl:template match="caution">
		<xsl:call-template name="admonition">
			<xsl:with-param name="type">Caution</xsl:with-param>
		</xsl:call-template>
	</xsl:template>
	<xsl:template match="para">
		<p>
			<xsl:apply-templates/>
		</p>
	</xsl:template>
	<xsl:template match="emphasis">
		<i>
			<xsl:apply-templates/>
		</i>
	</xsl:template>
</xsl:stylesheet>
