  function Y = IDCT8(X)
% X is an 8-by-m matrix
% Y is an 8-by-m matrix that satisfies C8*Y = X where C8 is the 
% 8-by-8 DCT matrix. Thus, Y = inv(C8)*X.

c = cos((1:7)*pi/16);
% Y = inv(D8)*X...
Y = [X(1,:)/8;X(2:8,:)/4];
% Y = T3'*Y...
Y = [Y(1,:)+c(4)*Y(5,:);...
     Y(1,:)-c(4)*Y(5,:);...
     c(2)*Y(3,:)+c(6)*Y(7,:);...
     c(6)*Y(3,:)-c(2)*Y(7,:);...
     c(1)*Y(2,:)+c(3)*Y(4,:)+c(5)*Y(6,:)+c(7)*Y(8,:);...
     c(3)*Y(2,:)-c(7)*Y(4,:)-c(1)*Y(6,:)-c(5)*Y(8,:);...
     c(5)*Y(2,:)-c(1)*Y(4,:)+c(7)*Y(6,:)+c(3)*Y(8,:);...
     c(7)*Y(2,:)-c(5)*Y(4,:)+c(3)*Y(6,:)-c(1)*Y(8,:)];

% Y = T2'*Y...
Y = [Y(1,:)+Y(3,:);...
     Y(2,:)+Y(4,:);...
     Y(2,:)-Y(4,:);...
     Y(1,:)-Y(3,:);...
     Y(5,:);...
     Y(6,:);...
     Y(7,:);...
     Y(8,:)];
    

% Y = T1'*Y...
Y = [Y(1,:)+Y(5,:);...
     Y(2,:)+Y(6,:);...
     Y(3,:)+Y(7,:);...
     Y(4,:)+Y(8,:);...
     Y(4,:)-Y(8,:);...
     Y(3,:)-Y(7,:);...
     Y(2,:)-Y(6,:);...
     Y(1,:)-Y(5,:)];