  function Y = DCT8CVL(X)
% X is an 8-by-m matrix
% Y = C8*X where C8 is the 8-by-8 DCT matrix
c = cos((1:7)*pi/16);
% Note that Y = C8*X = (T3*T2*T1)*X = T3*(T2*T1*X)) we
% proceed as follows...
% Y = T1*X...
Y = [ X(1,:)+X(8,:);...
      X(2,:)+X(7,:);...
      X(3,:)+X(6,:);...
      X(4,:)+X(5,:);...
      X(1,:)-X(8,:);...
      X(2,:)-X(7,:);...
      X(3,:)-X(6,:);...
      X(4,:)-X(5,:)];
% Y = T2*Y...
Y = [ Y(1,:)+Y(4,:);...
      Y(2,:)+Y(3,:);...
      Y(1,:)-Y(4,:);...
      Y(2,:)-Y(3,:);...
      Y(5,:);...
      Y(6,:);...
      Y(7,:);...
      Y(8,:)];
% Y = T3*Y...
Y = [Y(1,:)+Y(2,:);...
    c(1)*Y(5,:)+c(3)*Y(6,:)+c(5)*Y(7,:)+c(7)*Y(8,:);...
    c(2)*Y(3,:)+c(6)*Y(4,:);...
    c(3)*Y(5,:)-c(7)*Y(6,:)-c(1)*Y(7,:)-c(5)*Y(8,:);...
    c(4)*(Y(1,:)-Y(2,:));...
    c(5)*Y(5,:)-c(1)*Y(6,:)+c(7)*Y(7,:)+c(3)*Y(8,:);...
    c(6)*Y(3,:)-c(2)*Y(4,:);...
    c(7)*Y(5,:)-c(5)*Y(6,:)+c(3)*Y(7,:)-c(1)*Y(8,:)];

% -2 if loops are required to carry out these updates
% -3 if the T's are formed and Y = (T3*T2*T1)*X = T3*(T2*T1*X))
    