function ShowSplineQ()
% Examine spline quadrature on integral of sine from

clc

fprintf('Spline quadrature applied to f(x) = sin(x), [a,b] = [0,pi]\n\n')
fprintf('     m        Error\n')
fprintf('----------------------------\n')
for m = [5 50 500 5000]
   x    = linspace(0,pi,m);
   y    = sin(x);
   err  = abs(SplineQ(x,y)-quadl(@sin,0,pi,10^(-12)));
   disp(sprintf(' %5d      %10.3e',m,err))
end


fprintf('\n\n\nSpline quadrature applied to f(x) = humps(x), [a,b] = [0,1]\n\n')
fprintf('     m        Error\n')
fprintf('----------------------------\n')
for m = [5 50 500 5000]
   x    = linspace(0,1,m);
   y    = humps(x);
   err  = abs(SplineQ(x,y)-quadl(@humps,0,1,10^(-12)));
   disp(sprintf(' %5d      %10.3e',m,err))
end

  function numI = SplineQ(x,y)
% Integrates the spline interpolant of the data specified by the
% column n-vectors x and y. It is a assumed that x(1) < ... < x(n)
% and that the spline is produced by SPLINE. The integral is from
% x(1) to x(n).

S = spline(x,y);
[x,rho,L,k] = unmkpp(S);
sum = 0;
for i=1:L
   % Add in the integral from x(i) to x(i+1).
   h = x(i+1)-x(i);
   subI = h*(((rho(i,1)*h/4 + rho(i,2)/3)*h + rho(i,3)/2)*h + rho(i,4));
   sum = sum + subI;
end
numI = sum;