function ShowQuadQK()



disp(' Result Via       Error         AbsTol  RelTol')
disp('   Quadgk        Estimate                          ')
disp('-------------------------------------------------')
for delta = [.001 .0001]
   [Q2,E2] = quadgk(@(x) 100*sin(1./x),0,1,'AbsTol',delta,'RelTol',0,'MaxIntervalCount',100000);
   [Q3,E3] = quadgk(@(x) 100*sin(1./x),0,1,'AbsTol',0,'RelTol',delta,'MaxIntervalCount',100000);
   fprintf('%12.8f  %12.8f      %6.4f  %6.4f \n%12.8f  %12.8f      %6.4f  %6.4f \n',...
   Q2,E2,delta,0,Q3,E3,0,delta)
end




Q4 = quadgk(@(x) 1./sqrt(x),0,1)



% Infinite intervals...
mu = 1;
sigma = 3;
[Q6,errBound] = quadgk(@(x) NormalDist(x,mu,sigma),-inf,inf)
 

function y = NormalDist(x,mu,sigma)
y = exp(-((x-mu).^2/(2*sigma^2)))/(sigma*sqrt(2*pi));