  function [w,x] = GLWeights(m)
% w is a column m-vector consisting of the weights for the m-point Gauss-Legendre rule.
% x is a column m-vector consisting of the abscissae.
% m is an integer that satisfies 2 <= m <= 6.

w = ones(m,1); 
x = ones(m,1);
if m==2
   w(1) =  1.000000000000000; w(2) =  w(1);
   x(1) = -0.577350269189626; x(2) = -x(1);  
elseif m==3
   w(1) =  0.555555555555558; w(3) =  w(1);
   w(2) =  0.888888888888889;
   x(1) = -0.774596669241483; x(3) = -x(1);
   x(2) =  0.000000000000000;
elseif m==4
   w(1) =  0.347854845137454; w(4) =  w(1);
   w(2) =  0.652145154862546; w(3) =  w(2);
   x(1) = -0.861136311594053; x(4) = -x(1);
   x(2) = -0.339981043584856; x(3) = -x(2);  
elseif m==5
   w(1) =  0.236926885056189; w(5) =  w(1);
   w(2) =  0.478628670499366; w(4) =  w(2);
   w(3) =  0.568888888888889;
   x(1) = -0.906179845938644; x(5) = -x(1);
   x(2) = -0.538469310105683; x(4) = -x(2);
   x(3) =  0.000000000000000; 
else
   w(1) =  0.171324492379170; w(6) =  w(1);
   w(2) =  0.360761573048139; w(5) =  w(2);
   w(3) =  0.467913934572691; w(4) =  w(3);
   x(1) = -0.932469514203152; x(6) = -x(1);
   x(2) = -0.661209386466265; x(5) = -x(2);
   x(3) = -0.238619186083197; x(4) = -x(3);
end