% Script File:  ShowV 
% Plots 4 cubic polynomial interpolants of sin(x) on [0,2pi].
% The points of interpolation are randomly selected.
% Uses the Vandermonde method.

close all
x = linspace(0,2*pi,100)';
y = sin(x);
for eg=1:4
   x0 = 2*pi*sort(rand(4,1));
   y0 = sin(x0);
   % Interpolate (x0(i),y0(i)), i=1:d+1
   a = InterpV(x0,y0);
   % Display
   pVal = HornerV(a,x);
   subplot(2,2,eg)
   plot(x,y,x,pVal,'r',x0,y0,'*r',[0 2*pi],[0 0],':k')
   axis([0 2*pi -2 2])
end
