  function ShowRungePhenom()
% For n = 3:15, the equal-spacing interpolants of f(x) = 1/(1+25x^2) on [-1,1]'
% are of plotted.
close all
x = linspace(-1,1,100)'; 
y = ones(100,1)./(1 + 25*x.^2);
for d=3:15
   figure
   xEqual = linspace(-1,1,d+1)'; 
   yEqual = ones(d+1,1)./(1+25*xEqual.^2);
   p = polyfit(xEqual,yEqual,d);
   pValsEqual = polyval(p,x);
   plot(x,y,x,pValsEqual,xEqual,yEqual,'*',[-1 1],[0 0],':k')
   axis([-1 1 -1 2])
   title(sprintf('Equal-Spaced Degree-%1d Polynomial Interpolant of 1/(1+25x^2)',d),'fontsize',14)
end
