  function ShowMatPolyTools(d)
% Illustrates the Matlab functions polyfit and polyval.
% Interpolates f(x) = exp(-.2x)sin(x) with a degree-d polynomial
% at d+1 randomly selected points on the interval [0,5pi].
clc
close all
a = 0;
b = 5*pi;
% Generate m interpolation points where
m = d+1;
x0 = sort(rand(1,m))*b; x0(1) = a; x0(m) = b;
% Create the function via inline
f = inline('exp(-x/5).*sin(x)')
y0 = f(x0);
% Generate p...
p = polyfit(x0,y0,d);

% Display f, p, and the interpolation points..
x = linspace(a,b);
pvals = polyval(p,x);
fvals = f(x);
plot(x,fvals,x,pvals,'r',[-1 18],[0 0],':k')
hold on
plot(x0,y0,'.r','Markersize',15)
hold off
axis([-1 18 -1-max(abs(pvals)) 1+max(abs(pvals))])
title(sprintf('Interpolating exp(-x/5)sin(x) with a degree-%1d polynomial',d),'fontsize',14)






