  function ShowQUADs(f,a,b)
% Applies quad and quadl to the problem of integrating
% f(x) from x = a to x = b. Reports the computed integral
% and the number of required f-evaluations for tol = 1/10^p,
%  p = 3,6,9,12.
clc  
fprintf('                        quad                         quadl \n')                     
fprintf('   tol      Approximation   f-evals      Approximation   f-evals  \n') 
fprintf('-------------------------------------------------------------------\n')
for tol = [.001  .000001  .000000001  .000000000001]
    [Q,fcount]   = quad(f,a,b,tol);
    [QL,fcountL] = quadl(f,a,b,tol);
    fprintf('%5.1e   %15.12f %6d       %15.12f %6d    \n',tol,Q,fcount,QL,fcountL)
end


 


