function [QG,QK] = GaussKronrod(f,a,b)

% The 15 nodes...
x = [...
   -0.991455371120813;...	
   -0.949107912342759;... 	
   -0.864864423359769;... 	
   -0.741531185599394;... 	
   -0.586087235467691;... 		
   -0.405845151377397;... 	
   -0.207784955007898;... 		
    0.000000000000000;... 
    0.207784955007898;...
    0.405845151377397;...
    0.586087235467691;...
    0.741531185599394;...
    0.864864423359769;...
    0.949107912342759;...
    0.991455371120813];

% The Kronrod weights...
wK = [...    
    0.022935322010529;...
    0.063092092629979;...
    0.104790010322250;...
    0.140653259715525;...
    0.169004726639267;...
    0.190350578064785;...
    0.204432940075298;...
    0.209482141084728;...
    0.204432940075298;...
    0.190350578064785;...
    0.169004726639267;...
    0.140653259715525;...
    0.104790010322250;...
    0.063092092629979;...
    0.022935322010529];

% The Gauss weights associated with x(2:2:14)...  
 wG = [...   
    0.129484966168870;...
    0.279705391489277;...
    0.381830050505119;...
    0.417959183673469;...
    0.381830050505119;...
    0.279705391489277;...
    0.129484966168870];

fvals = f(((a+b)/2)+((b-a)/2)*x);
IK = (wK'*fvals)*(b-a)/2;
IG = (wG(2:2:14)'*fvals(2:2:14))*(b-a)/2;


The recommended error estimate is (200 |G7 - K15|)^{1.5}.