  function numI = CompQNC(f,a,b,m,n)
% Composite Newton-Cotes rule for the integral of f from a to b.
% f is a handle that points to a function of the form f(x) where x is a
% scalar. f must be defined on [a,b] and it must return a column vector if x is a
% column vector.
% m is an integer that satisfies 2 <= m <= 11.
% n is a positive integer.
% numI is the composite m-point Newton-Cotes approximation of the integral of f 
% from a to b with n equal length subintervals.
 
% Subinterval length...
Delta = (b-a)/n;
% NC spacing...
h = Delta/(m-1);
% The necessary f-evaluations...
x = linspace(a,b,n*(m-1)+1)';
f = f(x);
% Initializations for the required weighted avererage...
w = NCWeights(m);
numI = 0; 
first = 1; 
last = m;
for i=1:n
   %Add in the weighted average for the i-th subintegral...
   numI = numI + w'*f(first:last);
   first = last;
   last = last+m-1;
end 
numI = Delta*numI;