  function numI = AdaptQNC(f,a,b,m,tol)
% f is a handle that points to a function of the form f(x) where x is a
% scalar. f must be defined on [a,b] and it must return a column vector if x is a
% column vector.
% a,b are real scalars, m is an integer that satisfies 2 <= m <=11, and
% tol is a positive real.
% numI is a composite m-point Newton-Cotes approximation of the 
% integral of f(x) from a to b, where the subinterval partition is 
% determined adaptively. 

% Estimates based on composite rule with 1 and 2 subintervals...
A1 = CompQNC(f,a,b,m,1);
A2 = CompQNC(f,a,b,m,2);
% The error estimate...
d = 2*floor((m-1)/2)+1;
error = (A2-A1)/(2^(d+1)-1);
% Accept of reject A2?
if abs(error) <= tol
   % A2 is acceptable
   numI = A2+error;
else
   % Subdivide the problem...
   mid = (a+b)/2;
   numI = AdaptQNC(f,a,mid,m,tol/2) + AdaptQNC(f,mid,b,m,tol/2);
end